package cn.quantgroup.cashloanflowboss.spi.xyqb.entity;

import cn.quantgroup.cashloanflowboss.spi.xyqb.model.AssignStatusEnum;
import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.Data;

/**
 * 资产分配记录表
 */
@Data
@Entity
@Table(name = "assign_funding_record")
public class AssignFundingRecord {

  @Id
  @Column(name = "id")
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  private Long id;

  /**
   * 用户id
   */
  @Column(name = "user_id")
  private Long userId;


  /**
   * 资产订单表ID
   */
  @Column(name = "asset_order_id")
  private Long assetOrderId;

  /**
   * 分配状态
   */
  @Column(name = "assign_status")
  private AssignStatusEnum assignStatus;

  /**
   * 业务类型
   */
  @Column(name = "business_type")
  private Integer businessType;

  /**
   * 资金方id
   */
  @Column(name = "funding_corp_id")
  private Long fundingCorpId;

  /**
   * 被拒绝的资金方列表,以","分隔
   */
  @Column(name = "funding_block_list")
  private String fundingBlockList;

  /**
   * 备注
   */
  @Column(name = "remark")
  private String remark;

  /**
   * 尝试分配的次数
   */
  @Column(name = "try_assign_count")
  private Integer tryAssignCount;

  /**
   * 创建时间
   */
  @Column(name = "created_at")
  private Timestamp createdAt;

  /**
   * 更新时间
   */
  @Column(name = "updated_at")
  private Timestamp updatedAt;

}
