package cn.quantgroup.cashloanflowboss.spi.jolyne;

import cn.quantgroup.cashloanflowboss.spi.clf.model.LoanProgress;
import cn.quantgroup.cashloanflowboss.spi.jolyne.model.JolyneDB;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.LoanApplicationHistory;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.WaitingFundingCorpOperatePeople;
import cn.quantgroup.cashloanflowboss.spi.xyqb.service.XYQBCenterService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.ArrayList;

/**
 * function:
 * date: 2019/9/20
 *
 * @author: suntao
 */
@Slf4j
@Service
public class JolyneServiceImpl implements JolyneService {

    @Autowired
    private XYQBCenterService xyqbCenterService;
    @Autowired
    private JolyneCenter jolyneCenter;



    @Override
    public String executeSQL(JolyneDB jolyneDB, String jsonData) {
        return jolyneCenter.executeSQL(jolyneDB.getDbName(), jsonData);
    }


    @Override
    public void reloadJob(String jobName) {
        jolyneCenter.reloadJob(jobName);
    }

    @Async
    @Override
    public String delayUpdateWaitingXyqbSql(Long loanId, Long delayTime) {


        WaitingFundingCorpOperatePeople waitingFundingCorpOperatePeople = null;
        LoanApplicationHistory loanApplicationHistory;

        int i = 0;

        while (waitingFundingCorpOperatePeople != null) {
            try {
                Thread.sleep(delayTime);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }

            loanApplicationHistory = xyqbCenterService.findLoanApplicationHistoryById(loanId);
            if (loanApplicationHistory != null && LoanProgress.WAITING_FUND.equals(loanApplicationHistory.getProgress())) {
                // loan 状态是20 查询 waitingFundingCorpOperatePeople
                waitingFundingCorpOperatePeople = xyqbCenterService.findWaitingFundingCorpOperatePeopleByLoanId(loanId);
                break;
            }
            if (++ i > 20000) {
                return "fail";
            }
        }

        if (waitingFundingCorpOperatePeople.getCreatedAt().getTime() > (System.currentTimeMillis() - 5 * 60 * 1000)) {
            // 更新待放款时间(5分钟之前)
            ArrayList<String> updateWaitingFundingCorpOperatePeople = Lists.newArrayList();
            updateWaitingFundingCorpOperatePeople.add("update waiting_funding_corp_operate_people set created_at = DATE_SUB(created_at, interval 5 minute) where loan_application_history_id = " + loanId + ";");
            this.executeSQL(JolyneDB.XYQB, JolyneUtil.getJolneSql(updateWaitingFundingCorpOperatePeople));
        }

        try {
            Thread.sleep(200);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        reloadJob("cn.qg.clotho.job.FetchDataLoanJob");


        try {
            Thread.sleep(200);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        reloadJob("cn.qg.clotho.job.LoanDataJob");

        return "success";
    }

    @Override
    public String delayExecuteSql(JolyneDB jolyneDB, String jsonData, Long delayTime) {
        return null;
    }
}
