package cn.quantgroup.cashloanflowboss.spi.jolyne;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@FeignClient(name = "JolyneServiceCenter", url = "http://192.168.4.156:9001", fallback = JolyneCenter.Fallback.class)
public interface JolyneCenter {


    /**
     * 执行xyqb sql
     * @param jsonData
     * @return
     */
    @PostMapping(value = "/executeSQL/"+"${NAMESPACE}" + "/xyqb", consumes = "application/json")
    String executeXYQBSQL(String jsonData);

    /**
     * 查询xyqb sql
     * @param jsonData
     * @return
     */
    @PostMapping(value = "/querySQL/"+"${NAMESPACE}" + "/xyqb", consumes = "application/json")
    String queryXYQBSQL(String jsonData);


    /**
     * 执行 [xyqb_user] sql
     * @param jsonData
     * @return
     */
    @PostMapping(value = "/executeSQL/"+"${NAMESPACE}" + "/xyqb_user", consumes = "application/json")
    String executeXYQBUserSQL(String jsonData);

    @GetMapping(value = "/job/clotho-elastic-job/cn.qg.clotho.job.FetchDataLoanJob")
    void fetchDataLoanJob(@RequestParam("namespace") String namespace);

    @GetMapping(value = "/job/clotho-elastic-job/cn.qg.clotho.job.LoanDataJob")
    void loanDataJob(@RequestParam("namespace") String namespace);

    @Component
    class Fallback implements JolyneCenter {

        @Override
        public String executeXYQBSQL(String jsonData) {
            return null;
        }

        @Override
        public String queryXYQBSQL(String jsonData) {
            return null;
        }

        @Override
        public String executeXYQBUserSQL(String jsonData) {
            return null;
        }

        @Override
        public void fetchDataLoanJob(String namespace) {

        }

        @Override
        public void loanDataJob(String namespace) {

        }
    }
}
