package cn.quantgroup.cashloanflowboss.api.optlog.service;

import cn.quantgroup.cashloanflowboss.api.optlog.entity.OptHistoryLog;
import cn.quantgroup.cashloanflowboss.api.optlog.model.OptEnumName;
import cn.quantgroup.cashloanflowboss.api.optlog.repository.OptHistoryLogRepository;
import cn.quantgroup.cashloanflowboss.api.order.model.OrderBaseModel;
import cn.quantgroup.cashloanflowboss.api.order.util.OrderUtil;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ApplyRequestHistory;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfOrderMapping;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.WithdrawRecord;
import cn.quantgroup.cashloanflowboss.spi.clf.service.CLFCenterService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * function:
 * date: 2019/9/4
 *
 * @author: suntao
 */
@Service
public class OptHistoryLogServiceImpl implements OptHistoryLogService {


    @Autowired
    private CLFCenterService clfCenterService;
    @Autowired
    private OptHistoryLogRepository optHistoryLogRepository;


    @Override
    public List<OptHistoryLog> getAllOptHistoryLog(OrderBaseModel orderBaseModel) {

        ClfOrderMapping orderMapping = clfCenterService.findOrderMappingByChannelOrderNo(orderBaseModel.getChannelOrderNumber());
        if (orderMapping == null) {
            return null;
        }
        // 用户操作日志 进件。。。
        List<ApplyRequestHistory> applyRequestHistoryList = clfCenterService.findApplyRequestHistoryBySpecification(orderBaseModel);
        // 管理员操作日志 审批。。。
        List<OptHistoryLog> optHistoryLogList = getLocalOptHisttoryLog(orderBaseModel);

        // 提现记录
        List<WithdrawRecord> withdrawRecordList = clfCenterService.findWithdrawRecordList(orderBaseModel.getChannelOrderNumber(), orderMapping.getRegisteredFrom());
        List<OptHistoryLog> withdrawOptHistoryLogList = OrderUtil.convertWithdrawRecordList2UserOptHistoryLogList(withdrawRecordList);


        // 转换
        List<OptHistoryLog> userOptHistoryLogList = OrderUtil.convertApplyRequestHistoryList2OptHistoryLogList(applyRequestHistoryList, orderMapping);
        if (CollectionUtils.isNotEmpty(optHistoryLogList)) {
            userOptHistoryLogList.addAll(optHistoryLogList);
        }
        if (CollectionUtils.isNotEmpty(withdrawOptHistoryLogList)) {
            userOptHistoryLogList.addAll(withdrawOptHistoryLogList);
        }

        userOptHistoryLogList.sort((o1, o2)->{
            if (o1.getCreateTime().getTime() < o2.getCreateTime().getTime()) {
                return -1;
            } else {
                return 1;
            }
        });

        return userOptHistoryLogList;
    }

    /**
     * 只获取操作日志，boss库数据
     * @param orderBaseModel
     * @return
     */
    @Override
    public List<OptHistoryLog> getLocalOptHisttoryLog(OrderBaseModel orderBaseModel) {

        List<OptHistoryLog> page = this.optHistoryLogRepository.findAll((root, criteriaQuery, criteriaBuilder) -> {

            List<Predicate> predicates = new ArrayList<>();

            // 指定渠道号
            if (Objects.nonNull(orderBaseModel.getChannelId())) {
                predicates.add(criteriaBuilder.equal(root.get("channelId"), orderBaseModel.getChannelId().longValue()));
            }
            if (StringUtils.isNotEmpty(orderBaseModel.getChannelOrderNumber())) {
                predicates.add(criteriaBuilder.equal(root.get("channelOrderNumber"), orderBaseModel.getChannelOrderNumber()));
            }
            if (StringUtils.isNotEmpty(orderBaseModel.getApplyNo())) {
                predicates.add(criteriaBuilder.equal(root.get("applyNo"), orderBaseModel.getApplyNo()));
            }
            if (orderBaseModel.getLoanId() != null && orderBaseModel.getLoanId() > 0) {
                predicates.add(criteriaBuilder.equal(root.get("loanId"), orderBaseModel.getLoanId()));
            }

            // 设置查询条件
            criteriaQuery.where(criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()])));
            // 指定排序
            criteriaQuery.orderBy(criteriaBuilder.desc(root.get("id")));

            return criteriaQuery.getRestriction();
        });
        return page;
    }

    @Override
    public void save(OptHistoryLog optHistoryLog) {
        optHistoryLogRepository.save(optHistoryLog);
    }


    @Override
    public OptHistoryLog findByChannelOrderNumberAndOptName(String channelOrderNumber, OptEnumName opName) {
        return optHistoryLogRepository.findByChannelOrderNumberAndOptName(channelOrderNumber, opName.ordinal());
    }

    @Override
    public OptHistoryLog findByChannelOrderNumberAndOptNameAndSuccess(String channelOrderNumber, OptEnumName opName) {
        return optHistoryLogRepository.findByChannelOrderNumberAndOptNameAndSuccess(channelOrderNumber, opName.ordinal());
    }

}
