package cn.quantgroup.cashloanflowboss.api.log.controller;

import cn.quantgroup.cashloanflowboss.api.log.model.LoginFormModel;
import cn.quantgroup.cashloanflowboss.api.log.service.LogService;
import cn.quantgroup.cashloanflowboss.component.security.Authority;
import cn.quantgroup.cashloanflowboss.component.security.annotiation.Security;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * Created by WeiWei on 2019/7/22.
 */
@RestController
public class LogController {

    @Autowired
    private LogService logService;

    /**
     * 登入
     *
     * @param loginFormModel
     * @return
     */
    @CrossOrigin(allowCredentials = "true")
    @PostMapping("/login")
    public Result<Boolean> login(@RequestBody @Valid LoginFormModel loginFormModel) {
        return new Result<>(ApplicationStatus.SUCCESS, this.logService.login(loginFormModel.getUsername(), loginFormModel.getPassword()));
    }

    /**
     * 登出
     *
     * @return
     */
    @CrossOrigin(allowCredentials = "true")
    @DeleteMapping("/logout")
    @Security(authorityId = "Log.logout", authorities = Authority.READ)
    public Result<Boolean> logout() {
        return new Result<>(ApplicationStatus.SUCCESS, this.logService.logout());
    }

}
