package cn.quantgroup.cashloanflowboss.api.user.entity.boss;

import cn.quantgroup.cashloanflowboss.api.role.entity.boss.Role;
import cn.quantgroup.cashloanflowboss.api.user.dictionary.UserRank;
import cn.quantgroup.cashloanflowboss.api.user.dictionary.UserStatus;
import cn.quantgroup.cashloanflowboss.core.persistence.Primary;
import lombok.Data;

import javax.persistence.*;
import java.util.Date;
import java.util.Set;

/**
 * Created by WeiWei on 2019/7/22.
 */
@Data
@Entity
@Table(name = "user")
public class User extends Primary {

    /**
     * 用户名
     */
    @Column(name = "username")
    private String username;

    /**
     * 密码
     */
    @Column(name = "password")
    private String password;

    /**
     * 用户级别
     */
    @Enumerated(EnumType.STRING)
    @Column(name = "rank")
    private UserRank rank;

    /**
     * 用户角色列表
     */
    @OneToMany(fetch = FetchType.EAGER)
    @JoinTable(name = "user_role_mapping", joinColumns = @JoinColumn(name = "user_id"), inverseJoinColumns = @JoinColumn(name = "role_id"))
    private Set<Role> roles;

    /**
     * 用户状态
     */
    @Enumerated(EnumType.STRING)
    @Column(name = "status")
    private UserStatus status;

    /**
     * 最后登录时间
     */
    @Column(name = "last_login_time")
    private Date lastLoginTime;

}
