package cn.quantgroup.cashloanflowboss.spi.user.service;

import cn.quantgroup.cashloanflowboss.api.optlog.model.OptEnumName;
import cn.quantgroup.cashloanflowboss.core.annotation.opt.OperationAnno;
import cn.quantgroup.cashloanflowboss.core.base.Tuple;
import cn.quantgroup.cashloanflowboss.spi.jolyne.JolyneCenter;
import cn.quantgroup.cashloanflowboss.spi.user.repository.UserDetailRepository;
import cn.quantgroup.cashloanflowboss.spi.user.repository.UserExtInfoRepository;
import cn.quantgroup.cashloanflowboss.spi.util.HttpService;
import cn.quantgroup.cashloanflowboss.utils.JSONTools;
import cn.quantgroup.cashloanflowboss.utils.MD5Tools;
import cn.quantgroup.user.bean.UserInfo;
import cn.quantgroup.user.enums.IncomeEnum;
import cn.quantgroup.user.enums.IncomeRangeEnum;
import cn.quantgroup.user.retbean.XUser;
import cn.quantgroup.user.retbean.XUserDetail;
import cn.quantgroup.user.retbean.XUserExtInfo;
import cn.quantgroup.user.vo.UserSysResult;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * Created by Rocky on 2016/6/23.
 */
@Service
public class XyqbUserServiceImpl implements XyqbUserService {

    private static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger(XyqbUserServiceImpl.class);

    @Autowired
    private UserSysService userSysService;
    @Autowired
    private HttpService httpService;
    @Autowired
    private JolyneCenter jolyneCenter;
    @Autowired
    private UserDetailRepository userDetailRepository;
    @Autowired
    private UserExtInfoRepository userExtInfoRepository;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Value("${passportapi.http}")
    private String passportapiHttp;
    private static final ObjectMapper MAPPER = new ObjectMapper();



    /**
     * 查询用户
     *
     * @param userId
     * @return XyqbUser
     */
    @Override
    public XUser findXUserById(Long userId) {
        UserSysResult<XUser> userSysResult = userSysService.getService().findUserByUserId(userId);
        if (!userSysResult.isSuccess() || userSysResult.getData() == null) {
            LOGGER.error("用户不存在，userId=[{}]", userId);
            return null;
        }
        return userSysResult.getData();
    }


    @Override
    public XUserDetail findUserDetailByUserId(Long userId) {
        UserSysResult<XUserDetail> userDetailResult = userSysService.getService().findUserDetailByUserId(userId);
        if (!userDetailResult.isSuccess() || userDetailResult.getData() == null) {
            LOGGER.error("[findUserDetailByUserId_{}]向用户中心查询用户详情失败,userId={},result={}", userId, JSONTools.serialize(userDetailResult));
            return null;
        }
        return userDetailResult.getData();
    }

    @Override
    public String getUuid(String phoneNo) {
        if (StringUtils.isEmpty(phoneNo)) {
            return null;
        }
        UserSysResult<XUser> user = userSysService.getService().findUserByPhoneNo(phoneNo);
        if (Objects.isNull(user) || Objects.isNull(user.getData())) {
            return null;
        }
        return user.getData().getUuid();
    }

    @Override
    public XUser findUserByPhoneNo(String phoneNo) {
        UserSysResult<XUser> xuserResult = userSysService.getService().findUserByPhoneNo(phoneNo);
        if (xuserResult == null || xuserResult.getData() == null || !xuserResult.isSuccess()) {
            LOGGER.info("[findUserByPhoneNo]用户中心无用户信息,phoneNo={}，phoneDd5={}", phoneNo, MD5Tools.md5(phoneNo));
            return null;
        }
        return xuserResult.getData();
    }


    /**
     * 判断是否老用户
     *
     * @param phoneNo 手机号
     * @return 老用户 true；新用户 false
     */
    @Override
    public boolean isOldUser(String phoneNo) {
        UserSysResult<XUser> userData = userSysService.getService().findUserByPhoneNo(phoneNo);
        if (userData == null) {
            LOGGER.error("[user_isOldUser]查询用户失败, phoneNo={}", phoneNo);
            return false;
        }
        if (userData.getData() == null) {
            LOGGER.info("[user_isOldUser]没有查询到用户, phoneNo={}", phoneNo);
            return false;
        } else {
            return true;
        }
    }


    /**
     * 用户detail信息
     */
    @Override
    public UserInfo findUserByUuid(String uuid) {
        UserSysResult<UserInfo> userInfo = userSysService.getService().findUserInfoByUuid(uuid);
        if (!userInfo.isSuccess() || userInfo.getData() == null) {
            return null;
        }
        return userInfo.getData();
    }

    /**
     * 清除用户信息
     */
    @Override public Boolean cleanUserExtInfo(String phoneNo) {
        if (StringUtils.isEmpty(phoneNo)) {
            return false;
        }
        UserSysResult<XUser> user = userSysService.getService().findUserByPhoneNo(phoneNo);
        if (Objects.isNull(user) || Objects.isNull(user.getData())) {
            return false;
        }
        Long user_id = user.getData().getId();
        UserSysResult<Boolean> result = userSysService.getService().disableUser(user_id);
        UserSysResult<XUserExtInfo> userExtInfo = userSysService.getService().updateUserExtInfo(user_id, IncomeEnum.UNKNOWN,
            IncomeRangeEnum.UNKNOWN, null, null, null, null, null, null, null);
        if (!userExtInfo.isSuccess() || userExtInfo.getData() == null) {
            return false;
        }
        return true;
    }

    /**
     * 清除用户活跃订单
     * @param phoneNo
     * @return
     */
    @OperationAnno(channelNo = "#this[0]", opt = OptEnumName.USER_ORDER_CLEAN, succSPEL = "#this.key", optDetailSPEL = "#this.value")
    public Tuple<Boolean,String> cleanUserOrder(String phoneNo){
        UserSysResult<XUser> xUser = userSysService.getService().findUserByPhoneNo(phoneNo);
        if (xUser == null || xUser.getData() == null) {
            LOGGER.info("cleanUserOrder,清除用户活跃订单失败，未找到用户 phoneNo={}", phoneNo);
            return new Tuple<>(false,"清除用户活跃订单失败，未找到用户");
        }
        Long userId = xUser.getData().getId();
        ConcurrentMap<Object, Object> data = Maps.newConcurrentMap();
        ArrayList<Object> cancel_list = Lists.newArrayList();
        cancel_list.add("update xyqb.quota_credit set is_active=0 where user_id="+userId);
        cancel_list.add("update xyqb.quota_account set is_active=0 where user_id="+userId);
        cancel_list.add("update xyqb.loan_application_history set progress=16 where user_id="+userId);
        cancel_list.add("update xyqb.loan_application_history set is_active=0 where user_id="+userId);
        cancel_list.add("delete from apply_quota_record where user_id="+userId);
        cancel_list.add("delete from user_operation_history where user_id="+userId);
        data.put("sql",cancel_list);
        String cancel_result = jolyneCenter.executeXYQBSQL(JSONTools.serialize(data));
        JSONObject resp = JSONObject.parseObject(cancel_result);
        boolean result = (Objects.nonNull(resp) && resp.containsKey("code")) ? "0000".equals(resp.get("code")) : false;
        return new Tuple<>(result,result?"清除用户活跃订单成功":"清除用户活跃订单失败");
    }

    @Override public Boolean deleteByUserId(String phoneNo) {
        try{
            UserSysResult<XUser> xUser = userSysService.getService().findUserByPhoneNo(phoneNo);
            if (xUser == null || xUser.getData() == null) {
                LOGGER.error("cleanUserOrder,删除用户信息失败，未找到用户 phoneNo={}", phoneNo);
                return false;
            }
            Long userId = xUser.getData().getId();
            int i = userDetailRepository.deleteByUserId(userId);
            userExtInfoRepository.deleteByUserId(userId);
            Set<String> phoneNoKeys = redisTemplate.keys(phoneNo);
            if(phoneNoKeys!=null){
                redisTemplate.delete(phoneNoKeys);
            }
            Set<String> userKeys = redisTemplate.keys(String.valueOf(userId));
            if(userKeys!=null){
                redisTemplate.delete(userKeys);
            }
            String token_key = "userid-sessionvalue:cache::"+userId+":xyqb";
            String token = redisTemplate.opsForValue().get(token_key);
            if(token!=null && redisTemplate.keys(token)!=null){
                Set<String> tokenKeys = redisTemplate.keys(token);
                redisTemplate.delete(tokenKeys);
            }
        }catch (Exception e){
            LOGGER.error("cleanUserOrder,删除用户信息失败，phoneNo={}", phoneNo);
            return false;
        }
        return true;
    }
}
