package cn.quantgroup.cashloanflowboss.api.optlog.repository;

import cn.quantgroup.cashloanflowboss.api.optlog.entity.OptHistoryLog;
import cn.quantgroup.cashloanflowboss.api.order.entity.OrderApprove;
import cn.quantgroup.cashloanflowboss.core.persistence.CashLoanFlowBossDataSource;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * function:
 * date: 2019/8/12
 *
 * @author: suntao
 */
@CashLoanFlowBossDataSource
@Repository
public interface OptHistoryLogRepository extends PagingAndSortingRepository<OptHistoryLog, Long>, JpaSpecificationExecutor<OptHistoryLog> {

    List<OptHistoryLog> findByChannelOrderNumber(String channelOrderNumber);

    List<OptHistoryLog> findByCreditNumber(String creditOrderNumber);

}
