package cn.quantgroup.cashloanflowboss.spi.user.service;

import cn.quantgroup.cashloanflowboss.spi.user.service.UserSysService;
import cn.quantgroup.user.IUserSdkService;
import cn.quantgroup.user.UserSdkServiceFactory;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;

/**
 * Created by Miraculous on 2017/2/15.
 */
@Service
@Slf4j
public class UserSysServiceImpl implements UserSysService {

    @Autowired
    @Qualifier("httpClient")
    private CloseableHttpClient httpClient;
    @Value("${passportapi.http}")
    private String passportapiHttp;

    private IUserSdkService userSdkService; // http调用sdk


    @PostConstruct
    private void init() {
        userSdkService = UserSdkServiceFactory.generateSDKService(passportapiHttp, httpClient);
    }

    @Override
    public IUserSdkService getService() {
        return userSdkService;
    }

    @Override
    public IUserSdkService getMotanService() {
        return userSdkService;
    }

}
