package cn.quantgroup.cashloanflowboss.component.validator.constraints;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Objects;
import java.util.regex.Pattern;

/**
 * 座机电话格式约束验证器
 * <p>
 * Created by WeiWei on 2017/8/9.
 */
public class TelPhoneValidator implements ConstraintValidator<TelPhone, CharSequence> {

    private TelPhone annotation;

    public TelPhoneValidator() {

    }

    @Override
    public void initialize(TelPhone constraintAnnotation) {
        this.annotation = constraintAnnotation;
    }

    @Override
    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {

        if (Objects.isNull(value)) {
            return this.annotation.nullable();
        }

        return Pattern.matches(this.annotation.regularExpression(), value);

    }

}
