package cn.quantgroup.cashloanflowboss.api.order.controller;

import cn.quantgroup.cashloanflowboss.api.order.model.ApproveVo;
import cn.quantgroup.cashloanflowboss.api.order.model.LendingFormModel;
import cn.quantgroup.cashloanflowboss.api.order.model.OrderVo;
import cn.quantgroup.cashloanflowboss.api.order.service.OrderService;
import cn.quantgroup.cashloanflowboss.core.annotation.ChannelIdInit;
import cn.quantgroup.cashloanflowboss.core.annotation.CheckChannelRole;
import cn.quantgroup.cashloanflowboss.core.annotation.CheckChannelRoleByChannelOrderNumber;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * function:
 * date: 2019/8/8
 *
 * @author: suntao
 */

@RestController
@RequestMapping("/order")
public class OrderController {


    @Autowired
    private OrderService orderService;

    /**
     * 订单查询列表接口
     *
     * @param channelId
     * @param channelOrderNumber
     * @param pageNumber
     * @param pageSize
     * @return 返回中包含当前订单可操作的 button
     */
    @ChannelIdInit
    @CheckChannelRole
    @GetMapping("/list")
    public Result getOrders(Long channelId, String channelOrderNumber, Integer pageNumber, Integer pageSize) {
        return Result.buildSuccess(orderService.getOrders(channelId, channelOrderNumber, pageNumber, pageSize));
    }


    /**
     * 审批接口
     *
     * @param approveVo
     * @return
     */
    @ChannelIdInit
    @PostMapping("/approve")
    public Result approveOpt(@RequestBody @Valid ApproveVo approveVo) {
        return Result.buildSuccess(orderService.approveOpt(approveVo));
    }

    /**
     * 放款
     *
     * @return
     */
    @PostMapping("/lending")
    public Result<Boolean> lending(@RequestBody @Valid LendingFormModel lendingFormModel) {
        return Result.buildSuccess(this.orderService.lending(lendingFormModel));
    }

    /**
     * 贷前关单
     *
     * @return
     */
    @PostMapping("/cancel/loan")
    public Result<Boolean> cancelPreLoan(@RequestBody @Valid String channelOrderNumber) {
        return Result.buildSuccess(this.orderService.cancelPreLoan(channelOrderNumber));
    }

    /**
     * 贷后关单
     *
     * @return
     */
    @PostMapping("/cancel/after/loan")
    public Result<Boolean> cancelAfterLoan(@RequestParam @Valid String channelOrderNumber) {
        return Result.buildSuccess(this.orderService.cancelAfterLoan(channelOrderNumber));
    }

    /**
     * 订单历史状态查询接口
     *
     * @param channelOrderNumber
     * @return
     */
    @ChannelIdInit
    @CheckChannelRoleByChannelOrderNumber
    @GetMapping("/history/status")
    public Result getOrderHistoryStatus(String channelOrderNumber) {
        return Result.buildSuccess(orderService.getOrderHistoryStatus(channelOrderNumber));
    }


}
