package cn.quantgroup.cashloanflowboss.spi.opapi;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;


@Component
@FeignClient(name = "OPCenterService", url = "${op.api-host}", fallback = OPCenter.Fallback.class)
public interface OPCenter {
  @GetMapping(value = "/user/login")
  String getToken(@RequestParam("auth") String auth);

  @Component
  class Fallback implements OPCenter {

    @Override
    public String getToken(String auth) {
      return null;
    }
  }
}

