package cn.quantgroup.cashloanflowboss.json;
import cn.quantgroup.cashloanflowboss.spi.clf.model.LoanProgress;
import cn.quantgroup.cashloanflowboss.spi.clf.model.KANoticeType;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfOrderCallBack;
import cn.quantgroup.cashloanflowboss.spi.clf.model.CallbackRouter;
import java.sql.Timestamp;

import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfCallbackConfiguration;
import cn.quantgroup.cashloanflowboss.spi.clf.model.EncType;

import cn.quantgroup.cashloanflowboss.api.order.model.XyqbCurrentOrderStatusServiceResultModel;
import cn.quantgroup.cashloanflowboss.api.permissionmodule.entity.Permission;
import cn.quantgroup.cashloanflowboss.core.base.ServiceResult;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfChannelConfiguration;
import cn.quantgroup.cashloanflowboss.utils.JSONTools;
import com.fasterxml.jackson.core.type.TypeReference;
import org.junit.Test;
import org.springframework.boot.test.context.SpringBootTest;

import java.util.List;

/**
 * @description: test
 * @author:tao
 * @create: 2019-12-24 17:43
 */

public class JsonTest {


    @Test
    public void test() {

        String str = "{\"code\":0,\"message\":null,\"data\":{\"currentStatus\":{\"status\":\"APPROVE_ING\",\"updateTime\":1577084363000,\"kaNoticeType\":\"APPROVE_ING\"}},\"success\":true}";

        TypeReference<ServiceResult<XyqbCurrentOrderStatusServiceResultModel>> typeReference = new TypeReference<ServiceResult<XyqbCurrentOrderStatusServiceResultModel>>() {
        };
        ServiceResult<XyqbCurrentOrderStatusServiceResultModel> serviceResult = JSONTools.deserialize(str, typeReference);

        System.out.println(serviceResult);
    }

    @Test
    public void cClfChannelConfigurationTte() {
        ClfChannelConfiguration clfChannelConfiguration = new ClfChannelConfiguration();
        clfChannelConfiguration.setChannelName("融3");
        clfChannelConfiguration.setChannelCode("R360");
        clfChannelConfiguration.setRegisteredFrom(333L);
        clfChannelConfiguration.setIsActive(true);
        clfChannelConfiguration.setCreatedAt(new Timestamp(System.currentTimeMillis()));
        clfChannelConfiguration.setIsRequestStandard(true);
        clfChannelConfiguration.setEncType(EncType.AES);
        clfChannelConfiguration.setAesKey("");
        clfChannelConfiguration.setMd5Key("");
        clfChannelConfiguration.setSpiderCenterChannelCode("");
        clfChannelConfiguration.setSpiderCenterMerchantChannelCode("");
        clfChannelConfiguration.setAuthOption("");
        clfChannelConfiguration.setLoginPageUrl("");
        clfChannelConfiguration.setXyqbProductId("1");
        System.out.println(JSONTools.serialize(clfChannelConfiguration));
    }

    @Test
    public void cClfChannelCallbackTte() {
        ClfCallbackConfiguration clfCallbackConfiguration = new ClfCallbackConfiguration();
        clfCallbackConfiguration.setChannelId(333L);
        clfCallbackConfiguration.setIsLoanMakeup(false);
        clfCallbackConfiguration.setIsRepayMakeup(false);
        clfCallbackConfiguration.setLoanMakeupStrategy("");
        clfCallbackConfiguration.setRepayMakeupStrategy("");
        clfCallbackConfiguration.setIsActive(true);
        clfCallbackConfiguration.setOnlyNewUser(false);
        clfCallbackConfiguration.setCallbackServiceName("r");
        clfCallbackConfiguration.setCallbackNoPushProgress("rr");
        clfCallbackConfiguration.setPreProgress("rr");
        clfCallbackConfiguration.setRetryMaxTimes(5L);
        clfCallbackConfiguration.setCallbackRouter(CallbackRouter.API);


        System.out.println(JSONTools.serialize(clfCallbackConfiguration));
    }

    @Test
    public void cClfChannelCallbackTte3() {
        ClfOrderCallBack orderCallBack = new ClfOrderCallBack();
        orderCallBack.setCallbackStatus(KANoticeType.FUAD_ASSIFN_SUCC);
        orderCallBack.setRegisteredFrom(0L);
        orderCallBack.setCallbackUrl("");
        orderCallBack.setIsActive(false);
        orderCallBack.setCreatedAt(new Timestamp(new java.util.Date().getTime()));

        System.out.println(JSONTools.serialize(orderCallBack));
    }



}
