package cn.quantgroup.cashloanflowboss.core.aspect;

import cn.quantgroup.cashloanflowboss.api.channel.model.ChannelConfVo;
import cn.quantgroup.cashloanflowboss.api.channel.util.ChannelConfUtil;
import cn.quantgroup.cashloanflowboss.api.user.model.UserSessionInfo;
import cn.quantgroup.cashloanflowboss.api.user.service.UserSessionService;
import cn.quantgroup.cashloanflowboss.core.annotation.ChannelIdInit;
import cn.quantgroup.cashloanflowboss.core.annotation.CheckChannelRole;
import cn.quantgroup.cashloanflowboss.core.base.BossPageImpl;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.CodeSignature;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

/**
 * function:
 * date: 2019/8/6
 *
 * @author: suntao
 */
@Slf4j
@Component
@Aspect
@Order(Ordered.HIGHEST_PRECEDENCE)
public class RoleLoadAspect {

    @Autowired
    private UserSessionService userSessionService;

    @Pointcut("execution(* cn.quantgroup.cashloanflowboss.api.channel.controller.*.*(..))")
    private void channelRoleInit() {}

    @Around(value = "channelRoleInit()")
    public Object around(ProceedingJoinPoint pjp) {
        Object[] args = pjp.getArgs();
        MethodSignature methodSignature = (MethodSignature) pjp.getSignature();
        Method method = methodSignature.getMethod();

        // 如果是渠道用户登陆 默认加载channelId
        ChannelIdInit annotation = method.getAnnotation(ChannelIdInit.class);
        UserSessionInfo userSessionInfo = userSessionService.findUserSessionInfo();
        final Long channelIdInSession = userSessionInfo.getChannelId();
        if (annotation != null && ChannelConfUtil.channelRoleName.equals(userSessionInfo.getRoleInfo().getRoleName())) {
            String[] paramNames = ((CodeSignature)pjp.getSignature()).getParameterNames();
            for (int i = 0; i < paramNames.length; i++) {
                if (ChannelConfUtil.channelIdParamName.equals(paramNames[i])) {
                    args[i] = channelIdInSession;
                }
            }
        }

        // 如果是渠道用户登陆，参数中channelId 不是登陆用户channelId，返回 拒绝请求
        CheckChannelRole checkChannelRole = method.getAnnotation(CheckChannelRole.class);
        if (checkChannelRole != null  && ChannelConfUtil.channelRoleName.equals(userSessionInfo.getRoleInfo().getRoleName())) {
            Integer requestChannelId = -1;
            if (!checkChannelRole.isObjParam()) {
                String[] paramNames = ((CodeSignature)pjp.getSignature()).getParameterNames();
                for (int i = 0; i < paramNames.length; i++) {
                    // 是简单类型，多个参数 直接参数channelId
                    if (ChannelConfUtil.channelIdParamName.equals(paramNames[i])) {
                        // 找到channelId是第几个参数 i
                        Object requestChannelIdObj = args[i];
                        if (requestChannelIdObj == null) {
                            log.info("[CheckChannelRole]无channelId数据");
                            return Result.buildFial(ApplicationStatus.ARGUMENT_VALID_EXCEPTION);
                        }
                        requestChannelId = Integer.valueOf(String.valueOf(requestChannelIdObj));
                        if (requestChannelId != channelIdInSession.intValue()) {
                            log.info("[CheckChannelRole]渠道用户，登陆channelId与查询channelId不是同一个");
                            return Result.buildFial(ApplicationStatus.INVALID_AUTHORITY);
                        }
                    }
                }
            } else {
                Class paramClazz = checkChannelRole.paramClazz();
                if (paramClazz == ChannelConfVo.class) {
                    ChannelConfVo confVo = (ChannelConfVo) args[0];
                    final Long channelIdTemp = confVo.getBasicInfo().getChannelId();
                    if (channelIdTemp == null) {
                        log.info("[CheckChannelRole]无channelId数据");
                        return Result.buildFial(ApplicationStatus.ARGUMENT_VALID_EXCEPTION);
                    }
                    requestChannelId = channelIdTemp.intValue();
                }
            }
            if (requestChannelId != channelIdInSession.intValue()) {
                log.info("[CheckChannelRole]渠道用户，登陆channelId与查询channelId不是同一个");
                return Result.buildFial(ApplicationStatus.INVALID_AUTHORITY);
            }
        }
        // ======================================== CheckChannelRole end ==========================================

        try {
            return pjp.proceed(args);
        } catch (Throwable throwable) {
            log.error("请求失败，e={}", ExceptionUtils.getStackTrace(throwable));
            return Result.buildFial();
        }
    }


}
