package cn.quantgroup.cashloanflowboss.spi.xyqb.model;

import com.google.gson.annotations.JsonAdapter;
import lombok.Data;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * Created by zhaojiankun on 2018/4/10.
 */
@Data
public class QuotaCreditInfo implements Serializable {

    private static final long serialVersionUID = -1L;

    private Long id;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 渠道
     */
    private Long channel;

    /**
     * 和授信中心关联字段
     */
    private String orderNo;

    /**
     * 授信状态
     */
    private int creditStatus;

    /**
     * 授信信息来源
     */
    private int creditSource;

    /**
     * 产品id,关联产品表
     * KA 渠道来的数据，会提前把这个值传过来，需要存下来之后用
     */
    private Long productId;

    /**
     * 授信状态
     */
    private String remark;

    /**
     * 接收到风控回调时间，yyyy-MM-dd HH:mm:ss
     */
    private Timestamp receiveAt;

    private Timestamp createdAt;

    private Timestamp updatedAt;

    /**
     * 马甲包数据
     */
    private String loanVestInfo;

    /**
     * app 渠道
     */
    private String appChannel;

    /**
     * 借款用途
     */
    private String purpose;

}
