package cn.quantgroup.cashloanflowboss.api.channel.controller;

import cn.quantgroup.cashloanflowboss.api.channel.model.ChannelListModel;
import cn.quantgroup.cashloanflowboss.core.annotation.RoleDataLoad;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ChannelConfiguration;
import cn.quantgroup.cashloanflowboss.api.channel.service.ChannelConfService;
import cn.quantgroup.cashloanflowboss.api.user.model.Pagination;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * Created with suntao on 2019/8/2
 * @author suntao
 */
@RestController
@RequestMapping("channel")
public class ChannelConfController {


    @Autowired
    private ChannelConfService channelConfService;


    @RoleDataLoad
    @PostMapping("/info")
    public Page<ChannelListModel> channelInfo(Integer channelId, Integer pageNumber, Integer pageSize) {
        return channelConfService.getChannelInfo(pageNumber, pageSize, channelId);
    }


    @GetMapping("/cfg/info")
    public Result channelConfInfo(Integer channelId) {
        return channelConfService.getChannelConf(channelId);
    }



}
