package cn.quantgroup.cashloanflowboss.core.configuration.rabbitmq;

import cn.quantgroup.cashloanflowboss.core.Application;
import cn.quantgroup.cashloanflowboss.spi.rabbitmq.service.QueueService;
import cn.quantgroup.tech.brave.service.ITechRabbitBuilder;
import org.springframework.amqp.core.*;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerEndpoint;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.adapter.MessageListenerAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class OneClickMqConfig {


    @Value("${xyqb.loan.rabbitmq.connection.host}")
    private String host;
    @Value("${xyqb.loan.rabbitmq.connection.port}")
    private int port;
    @Value("${xyqb.loan.rabbitmq.connection.virtual-host}")
    private String vhost;
    @Value("${xyqb.loan.rabbitmq.connection.user}")
    private String username;
    @Value("${xyqb.loan.rabbitmq.connection.password}")
    private String password;

    @Value("${xyqb.loan.rabbitmq.exchange}")
    private String orderExchange;
    @Value("${quota_notice.one.click:one_click_quota_notice}")
    private String oneClickQuotaNotice;


    @Autowired
    @Qualifier("techRabbitBuilder")
    private ITechRabbitBuilder techRabbitBuilder;



    @Bean("oneClickConnectionFactory")
    public ConnectionFactory connectionFactory() {

        if (Application.isDebug()) {
            CachingConnectionFactory connectionFactory = new CachingConnectionFactory(host, port);
            connectionFactory.setCacheMode(CachingConnectionFactory.CacheMode.CHANNEL);
            connectionFactory.setChannelCacheSize(180 * 1000);
            //connectionFactory.setConnectionCacheSize(1024);
            connectionFactory.setUsername(username);
            connectionFactory.setPassword(password);
            connectionFactory.setVirtualHost(vhost);
            connectionFactory.setPublisherReturns(false);
            connectionFactory.setPublisherConfirms(false);
            return connectionFactory;
        }
        return null;
    }



    @Bean(name = "loanOrderAmqpAdmin")
    public AmqpAdmin amqpAdmin(ConnectionFactory connectionFactory) {
        return new RabbitAdmin(connectionFactory);
    }

    @Bean(name = "loanOrderExchange")
    public FanoutExchange fanoutExchange() {
        return new FanoutExchange(orderExchange);
    }

    @Bean(name = "oneClickQuotaNotice")
    public Queue loanOrderQueue() {
        return new Queue(oneClickQuotaNotice);
    }

    @Bean(name = "loanOrderBinding")
    public Binding bindingWaitGen(@Qualifier("loanOrderAmqpAdmin") AmqpAdmin amqpAdmin, @Qualifier("oneClickQuotaNotice") Queue oneClickQuotaNotice, @Qualifier("loanOrderExchange") FanoutExchange fanoutExchange) {
        Binding binding = BindingBuilder.bind(oneClickQuotaNotice).to(fanoutExchange);
        amqpAdmin.declareBinding(binding);
        return binding;
    }

    @Bean(name = "loanOrderRabbitTemplate")
    public RabbitTemplate contractTemplate(@Qualifier("oneClickConnectionFactory") ConnectionFactory connectionFactory) {
        if (Application.isDebug()) {
            RabbitTemplate template = techRabbitBuilder.createRabbitTemplate(connectionFactory);
            template.setExchange(orderExchange);
            return template;
        }
        return null;
    }


    /**
     * 订单状态消息处理监听
     * @param queueService
     * @param cachingConnectionFactory
     * @param oneClickQuotaNotice
     * @return
     */
    @Bean("oneClickLoanXyqbSimpleMessageListenerContainer")
    public SimpleMessageListenerContainer loanXyqbSimpleMessageListenerContainer(@Autowired QueueService queueService,
                                                                                 @Qualifier("oneClickConnectionFactory") CachingConnectionFactory cachingConnectionFactory,
                                                                                 @Qualifier("oneClickQuotaNotice") Queue oneClickQuotaNotice) {
        SimpleRabbitListenerContainerFactory simpleRabbitListenerContainerFactory = techRabbitBuilder
                .createSimpleRabbitListenerContainerFactory(cachingConnectionFactory);
        SimpleRabbitListenerEndpoint simpleRabbitListenerEndpoint = new SimpleRabbitListenerEndpoint();
        simpleRabbitListenerEndpoint.setQueues(oneClickQuotaNotice);
        simpleRabbitListenerEndpoint.setMessageListener(new MessageListenerAdapter(queueService, "oneClickHandleMessage"));
        SimpleMessageListenerContainer container = simpleRabbitListenerContainerFactory.createListenerContainer(simpleRabbitListenerEndpoint);
        container.setAcknowledgeMode(AcknowledgeMode.AUTO);
        container.setConcurrentConsumers(10);
        container.start();
        return container;
    }



}
