package cn.quantgroup.cashloanflowboss.spi.clotho.service;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Map;

/**
 * function:
 * date: 2019/8/9
 *
 * @author: suntao
 */

@Component
@FeignClient(name = "ClothoServiceCenter", url = "${fund.pay.api-host}", fallback = ClothoCenter.Fallback.class)
public interface ClothoCenter {

    @PostMapping(value = "/external/quota/auth_amount_audit/notify", consumes = "application/x-www-form-urlencoded")
    String approve(@RequestParam Map approveData);

    @Component
    class Fallback implements ClothoCenter {

        @Override
        public String approve(Map approveData) {
            return "error1";
        }
    }
}
