package cn.quantgroup.cashloanflowboss.spi.xyqb.entity;

import cn.quantgroup.cashloanflowboss.spi.clf.model.LoanProgress;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Objects;

/**
 * Created by FrankChow on 15/7/8.
 * 贷款记录表
 */
@Entity
@Table(name = "loan_application_history")
@Getter
@Setter
@ToString
public class LoanApplicationHistory implements Serializable {

    private static final long serialVersionUID = -1L;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "user_id")
    private Long userId;

    @Column(name = "channel_id")
    private Long channelId;

    // false表示借款申请是无效的或者已完成
    @Column(name = "is_active")
    private Boolean isActive = true;

    // 贷款进度 默认是02
    @Column(name = "progress")
    private LoanProgress progress = LoanProgress.USER_AUTHENTICATION_INCOMPLETE;

    @Column(name = "bank_card_id")
    private Long bankCardId;


    // 从哪个渠道注册过来
    @Column(name = "created_from")
    private Long createdFrom;



    @Column(name = "baitiao_merchant_id")
    private Long baitiaoMerchantId = -1L;

    // 上一次修改时间
    @Column(name = "updated_at")
    private Timestamp updatedAt;
    // 上一次修改时间
    @Column(name = "created_at")
    private Timestamp createdAt;

    @PrePersist
    public void prePersist() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        createdAt = timestamp;
        updatedAt = timestamp;
    }

    @PreUpdate
    public void preUpdate() {
        updatedAt = new Timestamp(System.currentTimeMillis());
    }


    public long parseChannelId() {
        return !Objects.equals(createdFrom, -1L) ? this.createdFrom : this.channelId;
    }

}
