package cn.quantgroup.cashloanflowboss.spi.jolyne;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.*;

@Component
@FeignClient(name = "JolyneServiceCenter", url = "http://192.168.4.156:9001", fallback = JolyneCenter.Fallback.class)
public interface JolyneCenter {


    /**
     * 由 JolyneService 请求
     * 执行sql
     * @param jsonData
     * @return
     */
    @PostMapping(value = "/executeSQL/"+"${NAMESPACE}" + "/{bdName}", consumes = "application/json")
    String executeSQL(@PathVariable(value = "bdName") String bdName , @RequestBody String jsonData);

    /**
     * 由 JolyneService 请求
     * 查询xyqb sql
     * @param jsonData
     * @return
     */
    @PostMapping(value = "/querySQL/"+"${NAMESPACE}" + "/{bdName}", consumes = "application/json")
    String querySQL(@PathVariable(value = "bdName") String bdName , @RequestBody String jsonData);


    /**
     * 刷新clotho定时任务
     * @param jobName
     */
    @GetMapping(value = "/job/clotho-elastic-job/{jobName}?namespace=${NAMESPACE}")
    void reloadJob(@PathVariable(value = "jobName")String jobName);

    @Component
    class Fallback implements JolyneCenter {

        @Override
        public String executeSQL(String bdName, String jsonData) {
            return null;
        }

        @Override
        public String querySQL(String bdName, String jsonData) {
            return null;
        }

        @Override
        public void reloadJob(String jobName) {

        }
    }
}
