package cn.quantgroup.cashloanflowboss.core.aspect;

import cn.quantgroup.cashloanflowboss.api.user.model.UserSessionInfo;
import cn.quantgroup.cashloanflowboss.api.user.service.UserSessionService;
import cn.quantgroup.cashloanflowboss.core.annotation.ChannelIdInit;
import cn.quantgroup.cashloanflowboss.core.base.BossPageImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.CodeSignature;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;

/**
 * function:
 * date: 2019/8/6
 *
 * @author: suntao
 */
@Slf4j
@Component
@Aspect
@Order(Ordered.HIGHEST_PRECEDENCE)
public class RoleDataLoadAspect {

    @Autowired
    private UserSessionService userSessionService;

    @Pointcut("execution(* cn.quantgroup.cashloanflowboss.api.channel.controller.*.*(..))")
    private void channelRoleInit() {}

    @Around(value = "channelRoleInit()")
    public Object around(ProceedingJoinPoint pjp) {
        Object[] args = pjp.getArgs();
        MethodSignature methodSignature = (MethodSignature) pjp.getSignature();
        Method method = methodSignature.getMethod();
        ChannelIdInit annotation = method.getAnnotation(ChannelIdInit.class);
        UserSessionInfo userSessionInfo = userSessionService.findUserSessionInfo();

        if (annotation != null && "channel_role".equals(userSessionInfo.getRoleInfo().getRoleName())) {
            String[] paramNames = ((CodeSignature)pjp.getSignature()).getParameterNames();
            for (int i = 0; i < paramNames.length; i++) {
                if ("channelId".equals(paramNames[i])) {
                    args[i] = userSessionInfo.getChannelId();
                }
            }
        }

        try {
            return pjp.proceed(args);
        } catch (Throwable throwable) {
            log.error("查询渠道列表错误e={}", ExceptionUtils.getStackTrace(throwable));
            return new BossPageImpl<>();
        }
    }


}
