package cn.quantgroup.cashloanflowboss.validator.constraints;

import cn.quantgroup.cashloanflowboss.validator.IDValidator;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Objects;

/**
 * 身份证约束验证器
 * <p>
 * Created by WeiWei on 2017/7/24.
 */
public class IDNumberValidator implements ConstraintValidator<IDNumber, CharSequence> {

    private static final IDValidator idValidator = new IDValidator();

    private IDNumber annotation;

    public IDNumberValidator() {

    }

    @Override
    public void initialize(IDNumber constraintAnnotation) {
        this.annotation = constraintAnnotation;
    }

    @Override
    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {

        if (Objects.isNull(value)) {
            return this.annotation.nullable();
        }

        return idValidator.validate(value.toString());

    }

}
