package cn.quantgroup.cashloanflowboss.validator.constraints;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Objects;
import java.util.regex.Pattern;

/**
 * 手机号格式约束验证器
 *
 * Created by WeiWei on 2017/8/9.
 */
public class PhoneValidator implements ConstraintValidator<Phone, CharSequence> {

    private Phone annotation;

    public PhoneValidator() {

    }

    @Override
    public void initialize(Phone constraintAnnotation) {
        this.annotation = constraintAnnotation;
    }

    @Override
    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {

        if(Objects.isNull(value)) {
            return this.annotation.nullable();
        }

        return Pattern.matches(this.annotation.regularExpression(), value);

    }

}
