package cn.quantgroup.cashloanflowboss.utils;

import cn.quantgroup.cashloanflowboss.core.Application;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import cn.quantgroup.cashloanflowboss.core.exception.ApplicationException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.IOException;
import java.util.Objects;

/**
 * JSON工具类，默认是用Jackson
 * <p>
 * Created by WeiWei on 2017/7/31.
 */
public class JSONTools {

    private static final ObjectMapper objectMapper;

    static {
        objectMapper = Application.getBean(ObjectMapper.class);
    }

    /**
     * 序列化
     *
     * @param data
     * @return
     */
    public static String serialize(Object data) {
        try {
            return objectMapper.writeValueAsString(data);
        } catch (JsonProcessingException e) {
            throw new ApplicationException(ApplicationStatus.JSON_DATA_EXCEPTION, e.getMessage());
        }
    }

    /**
     * 反序列化
     *
     * @param dataString
     * @param type
     * @param <T>
     * @return
     */
    public static <T> T deserialize(String dataString, TypeReference type) {

        if (Objects.isNull(dataString)) {
            return null;
        }

        try {
            return objectMapper.readValue(dataString, type);
        } catch (IOException e) {
            throw new ApplicationException(ApplicationStatus.JSON_DATA_EXCEPTION, e.getMessage());
        }

    }

    /**
     * 反序列化
     *
     * @param dataString
     * @param type
     * @param <T>
     * @return
     */
    public static <T> T deserialize(String dataString, Class<T> type) {

        if (Objects.isNull(dataString)) {
            return null;
        }

        try {
            return objectMapper.readValue(dataString, type);
        } catch (IOException e) {
            throw new ApplicationException(ApplicationStatus.JSON_DATA_EXCEPTION, e.getMessage());
        }

    }

    /**
     * 转换数据类型
     *
     * @param data
     * @param type
     * @param <T>
     * @return
     */
    public static <T> T convert(Object data, Class<T> type) {
        return deserialize(JSONTools.serialize(data), type);
    }

    /**
     * 转换数据类型
     *
     * @param data
     * @param type
     * @param <T>
     * @return
     */
    public static <T> T convert(Object data, TypeReference type) {
        return deserialize(JSONTools.serialize(data), type);
    }

}
