package cn.quantgroup.cashloanflowboss.spi.xyqb.model;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.*;

/**
 * Created with suntao on 2018/4/8
 */
@Data
@Slf4j
public class QuotaInfo {
    private Account account;
    private Rule rule;

    @Data
    public class Account {
        private Long id;
        private Long userId;
        private Long productId;
        /** 授信额度 */
        private BigDecimal totalAmount;
        /** 可用额度 */
        private BigDecimal availableAmount;
        /** 已使用额度 */
        private BigDecimal usedAmount;
        /** 冻结额度 */
        private BigDecimal freezeAmount;
    }

    @Data
    public class Rule {
        private Long fundCorpId;
//        /** 期数 {\"3000\":[3,6],\"6000\":[3,6,9]} */
//        private String terms;
        /** 期数 {\"3000\":[3,6],\"6000\":[3,6,9]} */
        private Map<String, TreeSet<Integer>> inputRule;
        /** 授信额度 */
        private BigDecimal maxAmount;
        /** 日利率 */
        private BigDecimal dayRate;
        /** 月利率 */
        private BigDecimal monthlyInterestRate;
        /** 年利率 == 综合利率 */
        private BigDecimal annualInterestRate;

        /** 月服务费 */
        private BigDecimal serviceFeeRate;

        // 外加属性，额度和期数的集合
        private List<TermsDetail> termsDetailList;
        // 所有期数 用逗号隔开
        private String termsStr;

        public TermsDetail getMaxAmountAndTerm() {
            if (CollectionUtils.isEmpty(termsDetailList)) {
                try {
                    loadTermsDetail();
                } catch (Exception e) {
                    return null;
                }
                return termsDetailList.get(termsDetailList.size() - 1);
            }else {
                return termsDetailList.get(termsDetailList.size() - 1);
            }
        }

        /**
         * 初始化额度-提现期数关系
         */
        public void loadTermsDetail() {
            TreeSet<Integer> termsSetAll = new TreeSet<>();
            if (CollectionUtils.isEmpty(termsDetailList)) {
                termsDetailList = new ArrayList<>();
//                Map<String,Integer[]> inputRule = Constants.GSON.fromJson(terms,  new TypeToken<Map<String, Integer[]>>() {}.getType());
//                for (Map.Entry<String,Integer[]> entry : inputRule.entrySet()) {
//                    TermsDetail termsDetailInner = new TermsDetail();
//                    termsDetailInner.setAmount(Long.valueOf(entry.getKey()));
//                    Integer[] termValues = entry.getValue();
//                    termsDetailInner.setTermDetail(termValues);
//                    Arrays.sort(termValues);
//                    termsDetailInner.setMinTerm(termValues[0]);
//                    termsDetailInner.setMaxTerm(termValues[termValues.length-1]);
//                    termsDetail.add(termsDetailInner);
//                }
                for (Map.Entry<String,TreeSet<Integer>> entry : inputRule.entrySet()) {
                    TermsDetail termsDetailInner = new TermsDetail();
                    termsDetailInner.setAmount(Long.valueOf(entry.getKey()));
                    TreeSet<Integer> termValues = entry.getValue();
                    termsDetailInner.setTerms(termValues);
                    termsSetAll.addAll(termValues);

                    termsDetailInner.setMinTerm(termValues.first());
                    termsDetailInner.setMaxTerm(termValues.last());
                    termsDetailList.add(termsDetailInner);
                }
                // 排序，按照额度升序排序
                Collections.sort(termsDetailList,(TermsDetail t1,TermsDetail t2)->{
                    // 当compareTo的返回值大于0的时候，进行元素的移位，其他情况，不作处理
                    try {
                        if (!Objects.isNull(t1.getAmount()) && !Objects.isNull(t2.getAmount())) {
                            // (x < y) ? -1 : ((x == y) ? 0 : 1);
                            return t1.getAmount().compareTo(t2.getAmount());
                        }
                        else {
                            return  Objects.isNull(t1.getAmount()) ? (Objects.isNull(t2.getAmount()) ? 0 : 1) : -1;
                        }
                    } catch (Exception ex) {
                        return 0;
                    }
                });
            }
            if (StringUtils.isEmpty(termsStr)) {
                if (CollectionUtils.isNotEmpty(termsSetAll)) {
//                    // 排序，按照额度升序排序
                    termsStr = StringUtils.join(termsSetAll,",");
                }
            }
        }
    }

    @Data
    public class TermsDetail {
        private Long amount;
        private TreeSet<Integer> terms;
        private int maxTerm;
        private int minTerm;
    }


    /**
     * 验证 查询额度 有效性
     * @param quotaInfo
     * @return
     */
    public static boolean validationQuotaInfo(QuotaInfo quotaInfo) {
        if (quotaInfo == null) {
            return false;
        }
        if (quotaInfo.getAccount() == null || quotaInfo.getRule() == null) {
            return false;
        }
        if (quotaInfo.getRule().getInputRule() == null) {
            return false;
        }
        try {
            QuotaInfo.TermsDetail maxAmountAndTerm = quotaInfo.getRule().getMaxAmountAndTerm();
            if (maxAmountAndTerm == null) {
                return false;
            }
            if (StringUtils.isEmpty(quotaInfo.getRule().termsStr)) {
                return false;
            }
        } catch (Exception e) {
            log.error("[exception][validationQuotaInfo]",e);
            return false;
        }
        return true;
    }

}
