package cn.quantgroup.cashloanflowboss.spi.xyqb.entity;

import lombok.Data;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.Date;

/**
 * Created by WeiWei on 2019/8/12.
 */
@Data
@Entity
@Table(name = "waiting_funding_corp_operate_people")
public class FundLending {

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private Long id;

    /**
     * 借款订单号
     */
    @Column(name = "loan_application_history_id")
    private String loanId;

    /**
     * 放款金额
     */
    @Column(name = "fund_amount")
    private BigDecimal amount;

    /**
     * 资方ID
     */
    @Column(name = "funding_corp_id")
    private Integer fundId;

    /**
     * 进度
     */
    @Column(name = "funding_corp_progress")
    private Integer progress;

    /**
     * 创建时间
     */
    @Column(name = "created_at")
    private Date createTime;

}
