package cn.quantgroup.cashloanflowboss.api.order.service;
import cn.quantgroup.cashloanflowboss.api.optlog.entity.OptHistoryLog;
import cn.quantgroup.cashloanflowboss.api.optlog.service.OptHistoryLogServiceImpl;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.CallbackFailRecord;
import cn.quantgroup.cashloanflowboss.spi.clf.model.LoanProgress;

import cn.quantgroup.cashloanflowboss.api.channel.entity.ChannelConf;
import cn.quantgroup.cashloanflowboss.api.channel.repository.ChannelConfRepository;
import cn.quantgroup.cashloanflowboss.api.channel.util.ChannelConfUtil;
import cn.quantgroup.cashloanflowboss.api.order.entity.OrderApprove;
import cn.quantgroup.cashloanflowboss.api.order.model.*;
import cn.quantgroup.cashloanflowboss.api.order.repository.OrderApproveRepository;
import cn.quantgroup.cashloanflowboss.api.order.util.OrderUtil;
import cn.quantgroup.cashloanflowboss.core.Application;
import cn.quantgroup.cashloanflowboss.core.base.ServiceResult;
import cn.quantgroup.cashloanflowboss.core.base.Tuple;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.CallbackRecord;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfOrderMapping;
import cn.quantgroup.cashloanflowboss.spi.clf.model.CallbackRecordVoModel;
import cn.quantgroup.cashloanflowboss.spi.clf.repository.ClfOrderMappingRepository;
import cn.quantgroup.cashloanflowboss.spi.clf.service.CLFCenterService;
import cn.quantgroup.cashloanflowboss.spi.clotho.service.ClothoCenterService;
import cn.quantgroup.cashloanflowboss.spi.jolyne.JolyneService;
import cn.quantgroup.cashloanflowboss.spi.jolyne.JolyneUtil;
import cn.quantgroup.cashloanflowboss.spi.opapi.OPCenter;
import cn.quantgroup.cashloanflowboss.spi.user.service.XyqbUserService;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.Contract;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.LoanApplicationHistory;
import cn.quantgroup.cashloanflowboss.spi.xyqb.repository.CancelPreLoanRepository;
import cn.quantgroup.cashloanflowboss.spi.xyqb.service.XYQBCenterService;
import cn.quantgroup.cashloanflowboss.utils.JSONTools;
import cn.quantgroup.user.retbean.XUser;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import javax.persistence.criteria.Predicate;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * function:
 * date: 2019/8/8
 *
 * @author: suntao
 */

@Slf4j
@Service
public class OrderServiceImpl implements OrderService{


    @Autowired
    private OptHistoryLogServiceImpl optHistoryLogService;

    @Autowired
    private ChannelConfRepository channelConfRepository;
    @Autowired
    private OrderApproveRepository orderApproveRepository;


    @Autowired
    private XyqbUserService xyqbUserService;
    @Autowired
    private XYQBCenterService xyqbCenterService;
    @Autowired
    private ClothoCenterService clothoCenterService;
    @Autowired
    private CLFCenterService clfCenterService;
    @Autowired
    private JolyneService jolyneService;



    @Autowired
    private ClfOrderMappingRepository clfOrderMappingRepository;

    @Autowired
    private CancelPreLoanRepository cancelPreLoanRepository;

    @Autowired
    private OPCenter opCenter;


    private static final String auth = "dXNlcj14dWV6aiZwYXNzd29yZD0xMjMxMjNxd2Vxd2U%3D";


    @Override
    public Page<OrderVo> orderList(Long channelId, String channelOrderNo, String applyNo, Long loanId, Integer pageNumber, Integer pageSize) {

        Page<ClfOrderMapping> page = this.clfOrderMappingRepository.findAll((root, criteriaQuery, criteriaBuilder) -> {

            List<Predicate> predicates = new ArrayList<>();

            // 指定渠道号
            if (Objects.nonNull(channelId)) {
                predicates.add(criteriaBuilder.equal(root.get("registeredFrom"), channelId.longValue()));
            }
            if (StringUtils.isNotEmpty(channelOrderNo)) {
                predicates.add(criteriaBuilder.equal(root.get("channelOrderNo"), channelOrderNo));
            }
            if (StringUtils.isNotEmpty(applyNo)) {
                predicates.add(criteriaBuilder.equal(root.get("applyNo"), applyNo));
            }
            if (loanId != null && loanId > 0) {
                predicates.add(criteriaBuilder.equal(root.get("loanId"), loanId));
            }

            // 设置查询条件
            criteriaQuery.where(criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()])));
            // 指定排序
            criteriaQuery.orderBy(criteriaBuilder.desc(root.get("id")));

            return criteriaQuery.getRestriction();

        }, new PageRequest(pageNumber, pageSize));


        return page.map(it -> {
            OrderVo orderVo = new OrderVo();
            orderVo.setId(it.getId());
            orderVo.setChannelId(it.getRegisteredFrom());
            orderVo.setChannelOrderNumber(it.getChannelOrderNo());
            if (!Application.getPrincipal().isChannel()) {
                orderVo.setLoanId(it.getLoanId());
                // 授信申请号，非渠道权限登陆显示admin及以上权限用户
                orderVo.setApplyNo(it.getApplyNo());
            }
            orderVo.setCreatedAt(it.getCreatedAt());
            if (StringUtils.isNotEmpty(it.getApplyNo())) {

                ServiceResult<XyqbCurrentOrderStatusServiceResultModel> xyqbCenterServiceXyqbOrderStatus = xyqbCenterService.getXyqbOrderStatus(it.getApplyNo(), it.getLoanId());
                log.info("[xyqbCenterService.getXyqbOrderStatus]xyqbOrderStatus={}", JSONTools.serialize(xyqbCenterServiceXyqbOrderStatus));
                if (xyqbCenterServiceXyqbOrderStatus.isSuccess()) {
                    QueryXyqbOrderStatus currentStatus = xyqbCenterServiceXyqbOrderStatus.getData().getCurrentStatus();

                    Tuple<String, List<OrderVo.OptButton>> currentStatusAndButtons = this.getCurrentStatusAndButtons(currentStatus, it);
                    orderVo.setStatus(currentStatusAndButtons.getKey());
                    if (Application.isDebug()) {
                        // 只有测试环境才需要订单操作
                        orderVo.setOpt(currentStatusAndButtons.getValue());
                    }
                    orderVo.setMessage("");
                } else {
                    orderVo.setStatus("未知，稍后查询");
                    orderVo.setMessage("订单查询错误");
                }
            } else {
                orderVo.setStatus("授信中");
                orderVo.setOpt(new ArrayList<>());
                orderVo.setMessage("");
            }

            return orderVo;
        });
    }

    /**
     *
     * @param approveVo
     * @return Tuple<Boolean 审批结果 true 审批完成 false 审批操作失败, Boolean 资产计划配置 true 配置没问题 false 配置需要检查>
     */

    @Override
    public Tuple<Boolean, Boolean> approveOpt(ApproveVo approveVo) {

        log.info("approveOpt,审批操作入参，approveVo={}", JSONTools.serialize(approveVo));

        if (StringUtils.isEmpty(approveVo.getAmount())) {
            // 如果UI 金额为空 默认4000
            approveVo.setAmount("4000");
        }
        if (approveVo.getPeriod() == null) {
            // 如果UI 期数为空 3期
            approveVo.setPeriod(3);
        }

        ClfOrderMapping orderMapping = clfOrderMappingRepository.findByChannelOrderNoLastOne(approveVo.getChannelOrderNumber());
        if (orderMapping == null) {
            log.info("approveOpt,审批失败，无订单 channelOrderNumber={}", approveVo.getChannelOrderNumber());
            return new Tuple<>(false, false);
        }

        if (Application.getPrincipal().isChannel() && !Application.getPrincipal().isSameChannel(orderMapping.getRegisteredFrom())) {
            log.info("approveOpt,审批失败，不是该渠道订单无法审批 channelOrderNumber={}", approveVo.getChannelOrderNumber());
            return new Tuple<>(false, false);
        }

        XUser xUser = xyqbUserService.findXUserById(orderMapping.getQgUserId());
        if (xUser == null) {
            log.info("approveOpt,审批失败，未找到用户 channelOrderNumber={}", approveVo.getChannelOrderNumber());
            return new Tuple<>(false, false);
        }

        ChannelConf channelConf = channelConfRepository.getByChannelId(orderMapping.getRegisteredFrom());
        if (channelConf == null) {
            log.info("approveOpt,审批失败，boss渠道配置为空 channelOrderNumber={}", approveVo.getChannelOrderNumber());
            return new Tuple<>(false, false);
        }

        // 额度有效期
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(Calendar.DAY_OF_YEAR, 7);


        Integer fundId = ChannelConfUtil.getFundIdByType(approveVo.getFundType(), channelConf);
        // 资方 及 期数额度规则
        String fundFormat = String.format(OrderUtil.financeProductsFormat, approveVo.getAmount(), approveVo.getAmount(),
                approveVo.getPeriod(), fundId);

        OrderApprove orderApproveExsit = orderApproveRepository.findByChannelOrderNumber(approveVo.getChannelOrderNumber());
        if (orderApproveExsit != null) {
            orderApproveExsit.setFundId(fundId);
            orderApproveExsit.setFundType(approveVo.getFundType());
            orderApproveExsit.setUpdateTime(new Date());
            orderApproveRepository.save(orderApproveExsit);
        } else {
            OrderApprove orderApprove = new OrderApprove();
            orderApprove.setChannelOrderNumber(approveVo.getChannelOrderNumber());
            orderApprove.setCreditNumber(orderMapping.getApplyNo());
            orderApprove.setChannelId(orderMapping.getRegisteredFrom());
            orderApprove.setFundId(fundId);
            orderApprove.setFundType(approveVo.getFundType());
            orderApprove.setCreateTime(new Date());
            orderApprove.setUpdateTime(new Date());
            orderApproveRepository.save(orderApprove);
        }



        Map<String, Object> data = new HashMap<>(16);
        data.put("code", 0);
        data.put("msg", "success");
        data.put("bizChannel", orderMapping.getRegisteredFrom());
        data.put("uuid", xUser.getUuid());
        data.put("bizNo", orderMapping.getApplyNo());
        data.put("bizType", channelConf.getBizType());
        data.put("auditResult", approveVo.getIsPass());
        data.put("amount", approveVo.getAmount());
        data.put("deadLine", calendar.getTime().getTime());
        data.put("financeProducts", fundFormat);

        // 发起审批
        log.info("[approveOpt] 向clotho发起审批，data={}", JSONTools.serialize(data));
        String approveStringResult = clothoCenterService.approve(data);
        Boolean corpPolicyValidate = false;
        try {

            corpPolicyValidate = xyqbCenterService.validateCorpPolicy(Long.valueOf(fundId), new Date());
        } catch (Exception e) {
            log.error("审批,资方校验异常，channelOrderNumber={}，fundId={}, e={}", orderMapping.getChannelOrderNo(), fundId, ExceptionUtils.getStackTrace(e));
        }

        // 操作记录
        OptHistoryLog optHistoryLog = new OptHistoryLog();
        optHistoryLog.setChannelOrderNumber(approveVo.getChannelOrderNumber());
        optHistoryLog.setCreditNumber(orderMapping.getApplyNo());
        optHistoryLog.setLoanId(orderMapping.getLoanId());
        optHistoryLog.setChannelId(orderMapping.getRegisteredFrom());
        optHistoryLog.setOptName("审批操作");
        optHistoryLog.setCreateTime(new Date());

        Boolean optResult;
        if ("success".equals(approveStringResult)) {

            optHistoryLog.setOptLogDetail(corpPolicyValidate ? "" : "资产计划未配置，请联系管理员配置");
            optHistoryLog.setOptResult(true);
            optResult = true;

            log.info("审批申请成功，channelOrderNumber={}", orderMapping.getChannelOrderNo());
        } else {
            optHistoryLog.setOptResult(false);
            optHistoryLog.setOptLogDetail("审批失败");
            log.info("审批申请失败，channelOrderNumber={}，requestParam={}", orderMapping.getChannelOrderNo(), JSONTools.serialize(data));
            optResult = false;
        }

        optHistoryLogService.save(optHistoryLog);

        return new Tuple<>(optResult, corpPolicyValidate);
    }

    /**
     * 已经自动，无须调用
     * 二次风控
     *
     * @param channelOrderNumber
     * @return
     */
    @Transactional
    @Override
    public boolean secondAudit(String channelOrderNumber) {

        String opName = "二次审批操作";



        boolean result = true;

        // 操作记录
        OptHistoryLog optHistoryLog = new OptHistoryLog();
        optHistoryLog.setChannelOrderNumber(channelOrderNumber);


        ClfOrderMapping orderMapping = this.clfOrderMappingRepository.findByChannelOrderNoLastOne(channelOrderNumber);
        if (orderMapping == null || orderMapping.getLoanId() == null) {
            log.info("secondAudit,orderMapping为空或者loanId为空，channelOrderNumber=".concat(channelOrderNumber));
            optHistoryLog.setOptName(opName);
            optHistoryLog.setOptLogDetail("orderMapping为空或者loanId为空,操作失败");
            optHistoryLog.setOptResult(false);
            optHistoryLog.setCreateTime(new Date());
            optHistoryLogService.save(optHistoryLog);
            return false;
        }

        optHistoryLog.setCreditNumber(orderMapping.getApplyNo());
        optHistoryLog.setLoanId(orderMapping.getLoanId());
        optHistoryLog.setChannelId(orderMapping.getRegisteredFrom());
        optHistoryLog.setOptName(opName);
        optHistoryLog.setCreateTime(new Date());

        OptHistoryLog optHistoryLogExsit = optHistoryLogService.findByChannelOrderNumberAndOptName(channelOrderNumber, opName);
        if (optHistoryLogExsit != null && optHistoryLogExsit.getOptResult()) {
            log.info("secondAudit,已经操作成功，channelOrderNumber=".concat(channelOrderNumber));
            optHistoryLog.setOptLogDetail("已经操作成功. 重复操作");
            optHistoryLog.setOptResult(true);
            optHistoryLogService.save(optHistoryLog);
            return true;
        }

        // 更新合同状态
        Contract conscont= xyqbCenterService.findContractByUserId(orderMapping.getQgUserId());
        if (conscont != null) {
            if (conscont.getGenerateStatus() != 2) {
                log.info("secondAudit,合同状态不对，channelOrderNumber=".concat(channelOrderNumber));
                optHistoryLog.setOptLogDetail("合同状态不对,手动修改,可能会导致合同签章获取失败,请更换新的身份证尝试");
                optHistoryLog.setOptResult(false);
                optHistoryLogService.save(optHistoryLog);
                // 修改合同状态
                ArrayList<String> updateContract = Lists.newArrayList();
                updateContract.add("update contract set generate_status = 2 where user_id = " + orderMapping.getQgUserId() + ";");
                jolyneService.executeXYQBSQL(JolyneUtil.getJolneSql(updateContract));
            }
        } else {
            // 合同为空 log表记录问题，UI用户查询
            log.info("secondAudit,合同为空，channelOrderNumber=".concat(channelOrderNumber));
            optHistoryLog.setOptLogDetail("合同为空,请更换新的身份证尝试");
            optHistoryLog.setOptResult(false);
            optHistoryLogService.save(optHistoryLog);
            // 不需要return
        }

        // 二次风控回调
        XUser xUser = xyqbUserService.findXUserById(orderMapping.getQgUserId());
        if (xUser == null) {
            log.info("[secendAudit]二次风控失败，未找到user channelOrderNumber={}", channelOrderNumber);
            optHistoryLog.setOptLogDetail("二次风控失败，未找到user");
            optHistoryLog.setOptResult(false);
            optHistoryLogService.save(optHistoryLog);
            return false;
        }
        ChannelConf channelConf = channelConfRepository.getByChannelId(orderMapping.getRegisteredFrom());
        if (channelConf == null) {
            log.info("[secendAudit]二次风控失败，未找到channelConf配置 channelOrderNumber={}", channelOrderNumber);
            optHistoryLog.setOptLogDetail("二次风控失败，未找到channelConf配置");
            optHistoryLog.setOptResult(false);
            optHistoryLogService.save(optHistoryLog);
            return false;
        }

        LoanApplicationHistory loanApplicationHistory = xyqbCenterService.findLoanApplicationHistoryById(orderMapping.getLoanId());

        if (LoanProgress.START_ORDER.equals(loanApplicationHistory.getProgress())) {
            // 50
            log.info("[secendAudit]二次风控发起,channelOrderNumber={}, bizType={}", channelOrderNumber, channelConf.getBizType());
            result = clothoCenterService.orderAuditNotify(xUser.getUuid(), orderMapping.getLoanId(), true, channelConf.getBizType());
            if (result) {
                log.info("[secendAudit]二次风控成功,channelOrderNumber={}, result={}", channelOrderNumber, result);
            } else {
                log.info("[secendAudit]二次风控失败，clotho返回失败 channelOrderNumber={}", channelOrderNumber);
                optHistoryLog.setOptLogDetail("二次风控失败，clotho返回失败");
                optHistoryLog.setOptResult(false);
                optHistoryLogService.save(optHistoryLog);
                return false;
            }
        } else if (LoanProgress.WAITING_FUND.equals(loanApplicationHistory.getProgress())) {
            // 20 已经回调过
            result = true;
        }

        jolyneService.delayUpdateWaitingXyqbSql(orderMapping.getLoanId(), 200L);

        optHistoryLog.setOptLogDetail("二次风控操作成功");
        optHistoryLog.setOptResult(true);
        optHistoryLogService.save(optHistoryLog);
        log.info("[secendAudit]二次风控操作 最后结果,channelOrderNumber={}, result={}", channelOrderNumber, result);

        return result;

    }

    /**
     * 放款
     *
     * @param lendingFormModel
     * @return
     */
    @Transactional
    @Override
    public boolean lending(LendingFormModel lendingFormModel) {

        boolean result = false;

        OrderApprove orderApprove = this.orderApproveRepository.findByChannelOrderNumber(lendingFormModel.getChannelOrderNumber());

        ClfOrderMapping orderMapping = this.clfOrderMappingRepository.findByChannelOrderNoAndRegisteredFromLastOne(lendingFormModel.getChannelOrderNumber(), lendingFormModel.getChannelId());

        String optDetail = "";

        // 操作记录
        OptHistoryLog optHistoryLog = new OptHistoryLog();
        optHistoryLog.setChannelOrderNumber(lendingFormModel.getChannelOrderNumber());
        optHistoryLog.setCreditNumber(orderMapping.getApplyNo());
        optHistoryLog.setLoanId(orderMapping.getLoanId());
        optHistoryLog.setChannelId(orderMapping.getRegisteredFrom());
        optHistoryLog.setOptName("放款操作");
        optHistoryLog.setCreateTime(new Date());


        // 更新合同状态
        Contract conscont= xyqbCenterService.findContractByUserId(orderMapping.getQgUserId());
        if (conscont == null) {
            // 合同为空 log表记录问题，UI用户查询
            optDetail = optDetail.concat("合同未生成，请注意，需要不用身份证才能自动生成合同,");
        }


        if (orderApprove.getFundType() == 0) {
            // 如果是非存管
            result = this.xyqbCenterService.payResultNotify(orderMapping.getLoanId(), lendingFormModel.getResult());
            log.info("[order_lending]非存管，放款结果通知,channelOrderNumber={}, result={}", lendingFormModel.getChannelOrderNumber(), result);
        } else {
            // p2p

            Map data = this.xyqbCenterService.queryLendingRecordCount(Long.valueOf(orderApprove.getFundId()));
            log.info("[order_lending][queryLendingRecordCount]查询待打款数量,channelOrderNumber={}, data={}", lendingFormModel.getChannelOrderNumber(), data);
            if (data.size() > 0) {
                if (Objects.nonNull(data.get("totalAmount")) && Objects.nonNull(data.get("totalCount"))) {
                    result = this.clothoCenterService.lending(orderApprove.getFundId(), new BigDecimal(String.valueOf(data.get("totalAmount"))), Integer.valueOf(String.valueOf(data.get("totalCount"))));
                    log.info("[order_lending]直投打款,channelOrderNumber={}, result={}", lendingFormModel.getChannelOrderNumber(), result);
                }
            }
        }

        if (result) {
            optDetail = optDetail.concat("放款操作成功");
            optHistoryLog.setOptResult(true);
        } else {
            optDetail = optDetail.concat("放款操作失败");
            optHistoryLog.setOptResult(false);
        }
        log.info("[order_lending]放款操作 最后结果,channelOrderNumber={}, result={}", lendingFormModel.getChannelOrderNumber(), result);

        optHistoryLog.setOptLogDetail(optDetail);
        optHistoryLogService.save(optHistoryLog);
        return result;

    }

    @Override
    public boolean cancel(OrderVo orderVo) {
        ClfOrderMapping orderMapping = clfOrderMappingRepository.findByChannelOrderNoLastOne(orderVo.getChannelOrderNumber());
        if (orderMapping == null) {
            log.info("executeXYQBSQL,关单失败，无订单 channelOrderNumber={}", orderVo.getChannelOrderNumber());
            return false;
        }

        XUser xUser = xyqbUserService.findXUserById(orderMapping.getQgUserId());
        if (xUser == null) {
            log.info("executeXYQBSQL,关单失败，未找到用户 channelOrderNumber={}", orderVo.getChannelOrderNumber());
            return false;
        }
        Long userId = xUser.getId();
        ConcurrentMap<Object, Object> data = Maps.newConcurrentMap();
        ArrayList<Object> cancel_list = Lists.newArrayList();
        cancel_list.add("update xyqb.quota_credit set is_active=0 where user_id=" + userId);
        cancel_list.add("update xyqb.quota_account set is_active=0 where user_id=" + userId);
        cancel_list.add("update xyqb.loan_application_history set progress=16 where user_id=" + userId);
        cancel_list.add("update xyqb.loan_application_history set is_active=0 where user_id=" + userId);
        cancel_list.add("delete from apply_quota_record where user_id=" + userId);
        cancel_list.add("delete from user_operation_history where user_id=" + userId);
        data.put("sql", cancel_list);
        String cancel_result = jolyneService.executeXYQBSQL(JSONTools.serialize(data));
        return "success".equals(cancel_result);
    }

    @Override
    public HistoryOrderStatusVoModel getOrderHistoryStatus(String channelOrderNumber) {
        ClfOrderMapping orderMapping = clfOrderMappingRepository.findByChannelOrderNoLastOne(channelOrderNumber);
        HistoryOrderStatusVoModel historyOrderStatusVoModel = new HistoryOrderStatusVoModel();
        if (orderMapping == null) {
            return historyOrderStatusVoModel;
        }
        OrderApprove orderApprove = orderApproveRepository.findByCreditNumber(orderMapping.getApplyNo());

        ServiceResult<XyqbHistoryOrderStatusServiceResultModel> xyqbOrderHistoryStatusResult = xyqbCenterService.getXyqbOrderHistoryStatus(orderMapping.getApplyNo(), orderMapping.getLoanId());
        if (xyqbOrderHistoryStatusResult.isSuccess()) {
            log.info("[getOrderHistoryStatus]查询成功channelOrderNumber={}, xyqbOrderHistoryStatusResult={}", channelOrderNumber, JSONTools.serialize(xyqbOrderHistoryStatusResult));
            XyqbHistoryOrderStatusServiceResultModel data = xyqbOrderHistoryStatusResult.getData();
            List<VoOrderStatus> historyStatusList = new ArrayList<>();
            for (QueryXyqbOrderStatus queryXyqbOrderStatus : data.getHistoryStatus()) {
                VoOrderStatus voOrderStatus = new VoOrderStatus();
                Tuple<String, String> stautsName = OrderUtil.KaNoticeTypeNameConvertChnName(queryXyqbOrderStatus.getStatus(), orderApprove);
                voOrderStatus.setStatus(stautsName.getValue());
                voOrderStatus.setUpdateTime(new Date(queryXyqbOrderStatus.getUpdateTime()));
                historyStatusList.add(voOrderStatus);
            }
            historyOrderStatusVoModel.setHistoryStatus(historyStatusList);
            return historyOrderStatusVoModel;
        } else {
            log.info("[getOrderHistoryStatus]查询失败channelOrderNumber={}, xyqbOrderHistoryStatusResult={}", channelOrderNumber, JSONTools.serialize(xyqbOrderHistoryStatusResult));
            return historyOrderStatusVoModel;
        }
    }

    /**
     * 贷前关单
     *
     * @param
     * @return
     */
    @Override
    public boolean cancelPreLoan(String channelOrderNumber) {
        boolean cancel = true;
        String token = null;
        ClfOrderMapping orderMapping = clfOrderMappingRepository.findByChannelOrderNoLastOne(channelOrderNumber);
        if (orderMapping == null) {
            log.info("cancelPreLoan,贷前关单失败，无订单 channelOrderNumber={}", channelOrderNumber);
            return false;
        }
        try{
            Long id = cancelPreLoanRepository.cancelPreLoan(orderMapping.getApplyNo());
            String response = opCenter.getToken(auth);
            JSONObject responseJ = JSONObject.parseObject(response);
            if(responseJ != null && responseJ.containsKey("data")){
                JSONObject data = (JSONObject) responseJ.get("data");
                if(data != null && data.containsKey("token")){
                    token = String.valueOf(data.get("token"));
                }
            }

            ConcurrentMap<Object, Object> data = Maps.newConcurrentMap();
            data.put("data",id);
            data.put("remark","贷前关单");
            String result = clothoCenterService.cancelPreLoan(data,token);
        }catch (Exception e){
            cancel = false;
            log.error(e.getMessage(),e);
        }
        return cancel;
    }

    /**
     * 贷后关单
     *
     * @param
     * @return
     */
    @Override
    public boolean cancelAfterLoan(String channelOrderNumber) {

        ClfOrderMapping orderMapping = this.clfOrderMappingRepository.findByChannelOrderNoLastOne(channelOrderNumber);

        if (orderMapping == null) {
            log.info("cancelAfterLoan,贷后关单失败，无订单  ={}", channelOrderNumber);
            return false;
        }
        if (orderMapping.getLoanId() == null) {
            log.info("cancelAfterLoan,贷后关单失败，loanId为空，channelOrderNumber={}", channelOrderNumber);
            return false;
        }
        ConcurrentMap<Object, Object> data = Maps.newConcurrentMap();
        data.put("loanId",orderMapping.getLoanId());
        data.put("userId",orderMapping.getQgUserId());
        data.put("flowNo", UUID.randomUUID());
        String id = clothoCenterService.cancelAfterLoan(data);

        return true;
    }

    /**
     * 查询订单历史推送记录
     * @param channelOrderNumber
     * @return
     */
    @Override
    public List<CallbackRecordVoModel> getOrderCallbackRecordList(String channelOrderNumber) {

        List<CallbackRecordVoModel> callbackRecordVoModelList = new ArrayList<>();

        ClfOrderMapping orderMapping = clfOrderMappingRepository.findByChannelOrderNoLastOne(channelOrderNumber);
        if (orderMapping == null) {
            return null;
        }

        List<CallbackRecord> callbackRecordList = clfCenterService.findCallbackRecordByApplyNo(orderMapping.getApplyNo());
        if (CollectionUtils.isNotEmpty(callbackRecordList)) {
            for (CallbackRecord callbackRecord : callbackRecordList) {
                CallbackRecordVoModel callbackRecordVoModel = new CallbackRecordVoModel();
                callbackRecordVoModel.setChannelOrderNo(orderMapping.getChannelOrderNo());
                callbackRecordVoModel.setApplyNo(orderMapping.getApplyNo());
                callbackRecordVoModel.setLoanId(orderMapping.getLoanId());
                callbackRecordVoModel.setTermNo(callbackRecord.getTermNo());
                callbackRecordVoModel.setNoticeType(callbackRecord.getNoticeType());
                callbackRecordVoModel.setCallbackStatus(callbackRecord.getCallbackStatus());
                callbackRecordVoModel.setChannelId(callbackRecord.getChannelId());
                callbackRecordVoModel.setCreatedAt(callbackRecord.getCreatedAt());
                callbackRecordVoModel.setUpdatedAt(callbackRecord.getUpdatedAt());
                callbackRecordVoModel.setTableName("Success");
                callbackRecordVoModelList.add(callbackRecordVoModel);
            }
        }

        List<CallbackFailRecord> callbackFailRecordList = clfCenterService.findCallbackFailRecordByApplyNo(orderMapping.getApplyNo());
        if (CollectionUtils.isNotEmpty(callbackFailRecordList)) {
            for (CallbackFailRecord callbackFailRecord : callbackFailRecordList) {
                CallbackRecordVoModel callbackFailRecordVoModel = new CallbackRecordVoModel();
                callbackFailRecordVoModel.setChannelOrderNo(orderMapping.getChannelOrderNo());
                callbackFailRecordVoModel.setApplyNo(orderMapping.getApplyNo());
                callbackFailRecordVoModel.setLoanId(orderMapping.getLoanId());
                callbackFailRecordVoModel.setTermNo(callbackFailRecord.getTermNo());
                callbackFailRecordVoModel.setNoticeType(callbackFailRecord.getNoticeType());
                callbackFailRecordVoModel.setCallbackStatus(callbackFailRecord.getCallbackStatus());
                callbackFailRecordVoModel.setChannelId(callbackFailRecord.getChannelId());
                callbackFailRecordVoModel.setRetryTimes(callbackFailRecord.getRetryTimes());
                callbackFailRecordVoModel.setFailCode(callbackFailRecord.getFailCode());
                callbackFailRecordVoModel.setCallbackRouter(callbackFailRecord.getCallbackRouter());
                callbackFailRecordVoModel.setIsActive(callbackFailRecord.getIsActive());
                callbackFailRecordVoModel.setExdata(callbackFailRecord.getExdata());
                callbackFailRecordVoModel.setCreatedAt(callbackFailRecord.getCreatedAt());
                callbackFailRecordVoModel.setUpdatedAt(callbackFailRecord.getUpdatedAt());
                callbackFailRecordVoModel.setTableName("Fail");
                callbackRecordVoModelList.add(callbackFailRecordVoModel);
            }
        }
        return callbackRecordVoModelList;
    }

    /**
     * 查询还款计划
     * @param channelOrderNumber
     * @param loanId
     * @return
     */
    @Override
    public Object findRepaymentPlan(String channelOrderNumber, Long loanId) {
        if (loanId == null || loanId < 1) {
            ClfOrderMapping orderMapping = clfCenterService.findOrderMappingByChannelOrderNo(channelOrderNumber);
            if (orderMapping == null || orderMapping.getLoanId() == null) {
                return null;
            }
            loanId = orderMapping.getLoanId();
        }

        // xyqbCenterService.findRepaymentPlan(loanId);
        return null;
    }

    @Override
    public void loadSecondAuditJob() {
        jolyneService.fetchDataLoanJob();
        jolyneService.loanDataJob();
    }


    /**
     * 查询订单状态
     * @param currentStatus
     * @param orderMapping
     * @return
     */
    private Tuple<String, List<OrderVo.OptButton>> getCurrentStatusAndButtons(QueryXyqbOrderStatus currentStatus, ClfOrderMapping orderMapping) {
        Tuple tuple = new Tuple();
        List<OrderVo.OptButton> buttonList = new ArrayList<>();

        if (currentStatus != null) {
            if (StringUtils.isNotEmpty(currentStatus.getStatus())) {
                OrderVo.OptButton buttonBeforeCancel = new OrderVo.OptButton();
                buttonBeforeCancel.setAction(OrderVo.OptButtonAction.cancel.name());
                buttonBeforeCancel.setName(OrderVo.OptButtonAction.cancel.getDesc());
                switch (currentStatus.getStatus()) {
                    case "CREDIT_SUCC" :
                        // 授信成功 需要 审批
                        OrderVo.OptButton buttonApprove = new OrderVo.OptButton();
                        buttonApprove.setAction(OrderVo.OptButtonAction.audit.name());
                        buttonApprove.setName(OrderVo.OptButtonAction.audit.getDesc());
                        buttonList.add(buttonApprove);
                        tuple.setKey("授信成功");
                        tuple.setValue(buttonList);
                        return tuple;
                    case "APPROVE_ING" :
                        OrderApprove orderApprove = orderApproveRepository.findByCreditNumber(orderMapping.getApplyNo());
                        if (orderApprove == null) {
                            OrderVo.OptButton buttonApprove2 = new OrderVo.OptButton();
                            buttonApprove2.setAction(OrderVo.OptButtonAction.audit.name());
                            buttonApprove2.setName(OrderVo.OptButtonAction.audit.getDesc());
                            buttonList.add(buttonApprove2);
                            tuple.setKey("授信成功,待审批");
                            tuple.setValue(buttonList);
                        } else {
                            tuple.setKey("审批中(等待几分钟)");
                            tuple.setValue(buttonList);
                        }
                        return tuple;
                    case "REJECT" :
                        tuple.setKey("审批拒绝");
                        tuple.setValue(buttonList);
                        return tuple;
                    case "FUAD_ASSIFN_SUCC" :
                        tuple.setKey("审批通过，待提现");
                        buttonList.add(buttonBeforeCancel);
                        tuple.setValue(buttonList);
                        return tuple;
                    case "WITHDRAW_APPROVING" :
                        tuple.setKey("提现成功，待二次风控审批");
                        // 更改放款时间,二次风控回调
                        OrderVo.OptButton secondAudit2 = new OrderVo.OptButton();
                        secondAudit2.setAction(OrderVo.OptButtonAction.second_audit.name());
                        secondAudit2.setName(OrderVo.OptButtonAction.second_audit.getDesc());
                        buttonList.add(secondAudit2);
                        buttonList.add(buttonBeforeCancel);
                        tuple.setValue(buttonList);
                        return tuple;
                    case "WITHDRAW" :
                        LoanApplicationHistory loanApplicationHistory = xyqbCenterService.findLoanApplicationHistoryById(orderMapping.getLoanId());
                        if (loanApplicationHistory != null) {
                            if (LoanProgress.WAITING_FUND.equals(loanApplicationHistory.getProgress())) {
                                // 更改放款时间,二次风控回调
                                // 提现申请成功 需要放款
                                tuple.setKey("二次风控审批中");
                            } else if (LoanProgress.FINAL_SENDED_TO_FUNDING_CORP.equals(loanApplicationHistory.getProgress())) {
                                tuple.setKey("待放款");
                                OrderVo.OptButton buttonPaySucc = new OrderVo.OptButton();
                                buttonPaySucc.setAction(OrderVo.OptButtonAction.pay_succ.name());
                                buttonPaySucc.setName(OrderVo.OptButtonAction.pay_succ.getDesc());
                                buttonList.add(buttonPaySucc);
                                OrderVo.OptButton buttonPayFail = new OrderVo.OptButton();
                                buttonPayFail.setAction(OrderVo.OptButtonAction.pay_fail.name());
                                buttonPayFail.setName(OrderVo.OptButtonAction.pay_fail.getDesc());
                                buttonList.add(buttonPayFail);
                                buttonList.add(buttonBeforeCancel);
                            }
                            tuple.setValue(buttonList);
                        }
                        return tuple;
                    case "PAY_ING" :
                        tuple.setKey("放款中(等待几分钟)");
                        buttonList.add(buttonBeforeCancel);
                        tuple.setValue(buttonList);
                        return tuple;
                    case "FUND_WAITING_WITHDRAW" :
                        tuple.setKey("放款到存管账户，待存管提现");
                        OrderVo.OptButton cancelAfterButton0 = new OrderVo.OptButton();
                        cancelAfterButton0.setAction(OrderVo.OptButtonAction.cancel_after.name());
                        cancelAfterButton0.setName(OrderVo.OptButtonAction.cancel_after.getDesc());
                        buttonList.add(cancelAfterButton0);
                        tuple.setValue(buttonList);
                        return tuple;
                    case "FUND_SUCC" :
                        OrderApprove orderApprove2 = orderApproveRepository.findByCreditNumber(orderMapping.getApplyNo());
                        if (orderApprove2 != null && orderApprove2.getFundType() != 0) {
                            // 是存管
                            tuple.setKey("放款到存管，待存管提现");
                            OrderVo.OptButton cancelAfterButton = new OrderVo.OptButton();
                            cancelAfterButton.setAction(OrderVo.OptButtonAction.cancel_after.name());
                            cancelAfterButton.setName(OrderVo.OptButtonAction.cancel_after.getDesc());
                            buttonList.add(cancelAfterButton);
                            OrderVo.OptButton withdrawSecondButton = new OrderVo.OptButton();
                            withdrawSecondButton.setAction(OrderVo.OptButtonAction.withdraw_second.name());
                            withdrawSecondButton.setName(OrderVo.OptButtonAction.withdraw_second.getDesc());
                            buttonList.add(withdrawSecondButton);
                        } else {
                            tuple.setKey("放款成功");
                        }
                        tuple.setValue(buttonList);
                        return tuple;
                    case "FUND_WITHDRAW_SUCC" :
                        tuple.setKey("存管提现成功");
                        tuple.setValue(buttonList);
                        return tuple;
                    case "FUND_FAIL" :
                        tuple.setKey("放款失败");
                        tuple.setValue(buttonList);
                        return tuple;
                    case "ALL_REPAID" :
                        tuple.setKey("已结清");
                        tuple.setValue(buttonList);
                        return tuple;
                    case "CANCEL_LOAN" :
                        tuple.setKey("已关单");
                        tuple.setValue(buttonList);
                        return tuple;
                    case "CANCEL_AFTER_LOAN" :
                        tuple.setKey("存管提现超时或贷后关单");
                        tuple.setValue(buttonList);
                        return tuple;
                    default:
                        tuple.setKey("未知状态");
                        tuple.setValue(buttonList);
                        return tuple;
                }
            }

        } else {
            tuple.setKey("未知状态");
            tuple.setValue(buttonList);
            return tuple;
        }
        tuple.setKey("未知状态");
        tuple.setValue(buttonList);
        return tuple;
    }

}
