package cn.quantgroup.cashloanflowboss.component.security;

import cn.quantgroup.cashloanflowboss.component.security.annotiation.Security;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;

/**
 * Created by WeiWei on 2018/2/1.
 */
@Configuration
public class SecurityConfiguration {

    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public SecurityPointcut<Security> securityPointcut() {
        return new SecurityPointcut<>(Security.class);
    }

    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public SecurityInterceptor securityInterceptor() {
        return new SecurityInterceptor();
    }

    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public SecurityAdvisor securityAdvisor() {
        return new SecurityAdvisor(securityPointcut(), securityInterceptor());
    }

}
