package cn.quantgroup.cashloanflowboss.api.channel.controller;

import cn.quantgroup.cashloanflowboss.api.channel.entity.clf.ChannelConfiguration;
import cn.quantgroup.cashloanflowboss.api.channel.service.ChannelConfService;
import cn.quantgroup.cashloanflowboss.api.user.entity.boss.User;
import cn.quantgroup.cashloanflowboss.api.user.model.Pagination;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;
import java.util.Map;

/**
 * Created with suntao on 2019/8/2
 * @author suntao
 */
@RestController
@RequestMapping("channel")
public class ChannelConfController {


    @Autowired
    private ChannelConfService channelConfService;


    @GetMapping("/info")
    public Page<ChannelConfiguration> channelInfo(@RequestParam @Valid Pagination pagination, Integer channelId) {
        return channelConfService.getChannelInfo(pagination, channelId);
    }


    @GetMapping("/cfg/info")
    public Result channelConfInfo(Integer channelId) {
        return channelConfService.getChannelConf(channelId);
    }



}
