package cn.quantgroup.xyqb.controller.internal.user;

import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import cn.quantgroup.tech.util.TechEnvironment;
import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.controller.external.sms.SmsController;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.service.sms.ISmsService;
import lombok.extern.slf4j.Slf4j;

/**
 * 内部定制接口
 * 
 * @author yutong
 * @time 2021-04-28
 */
@Slf4j
@RestController
@RequestMapping("/innerapi/custom")
@Validated
public class InnerCustomController implements IBaseController {

	private final static String RANDOM_CHARS = "0123456789";

	@Autowired
	private ISmsService smsService;

    /**
     * VCC定制 - 无极验，发送短信验证码
     *
     * @param phoneNo      - 手机号
     * @param registerFrom -
     * @param deviceId     -
     * @param appName      -
     * @param smsMerchant  - 短信模板/类型
     * @see SmsController#sendVccSmsCode(String, String, String, String, String)
     */
	@RequestMapping("/send_vcc_sms_code")
	public JsonResult sendVccSmsCode(@RequestParam String phoneNo, @RequestParam(required = false) String registerFrom,
			@RequestParam(required = false) String deviceId,
			@RequestParam(required = false, defaultValue = "") String appName,
			@RequestParam(required = false) String smsMerchant) {
		log.info("VCC-越过极验发送验证码, phoneNo:{}, registerFrom:{}", phoneNo, registerFrom);
		String randomCode = getRandomCode(Constants.SMS_CODE_LEN_6);
		return smsService.sendVerificationCode2New(phoneNo, randomCode, deviceId, true, appName, smsMerchant, getIp());
	}

	private String getRandomCode(int count) {
		if (TechEnvironment.isPro()) {
			return RandomStringUtils.random(count, RANDOM_CHARS);
		}
		switch (count) {
		case 6:
			return "000000";
		default:
			return Constants.SUCCESS_CODE;
		}
	}
}
