package cn.quantgroup.xyqb.util;

import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import java.util.Calendar;
import java.util.Date;

/**
 * joda-time
 * <p>
 * Date: 2019/11/6
 * Time: 上午11:18
 *
 * @author: yangrui
 */
public class DateUtils {

    public static final String YMD_HMS_FORMAT = "yyyy-MM-dd HH:mm:ss";

    /**
     * @param dateTimeStr
     * @param formatStr
     * @return
     */
    public static Date strToDate(String dateTimeStr, String formatStr) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern(formatStr);
        DateTime dateTime = dateTimeFormatter.parseDateTime(dateTimeStr);
        return dateTime.toDate();
    }

    /**
     * 计算当前时间到当天 23:59:59.999 时间差,
     * 返回时间差(单位秒)
     *
     * @return
     */
    public static long getSeconds() {
        Calendar endOfDay = Calendar.getInstance();
        endOfDay.set(Calendar.HOUR_OF_DAY, 23);
        endOfDay.set(Calendar.MINUTE, 59);
        endOfDay.set(Calendar.SECOND, 59);
        endOfDay.set(Calendar.MILLISECOND, 999);
        long timeStamp = endOfDay.getTimeInMillis();
        long now = System.currentTimeMillis();
        return (timeStamp - now) / 1000;
    }

    /**
     * 获取时间差天数
     *
     * @param bDate begin
     * @param eDate end
     * @return 时间差天数
     */
    public static long dayDiff(Date bDate, Date eDate) {
        return  ((bDate.getTime() - eDate.getTime()) / (1000 * 3600 * 24));
    }
}
