package cn.quantgroup.xyqb.service.mq.impl;

import cn.quantgroup.xyqb.model.UserStatistics;
import cn.quantgroup.xyqb.service.mq.IVestService;
import com.alibaba.fastjson.JSONObject;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

/**
 * Created by xuran on 2017/6/21.
 * 用户统计信息
 */
@Slf4j
@Service("loanVestMqService")
public class LoanVestMqServiceImpl implements IVestService {

    @Resource
    @Qualifier("rabbitTemplate")
    private RabbitTemplate rabbitTemplate;

    /**
     * 发送用登陆统计信息
     *
     * @param message 订单信息
     */
    @Override
    @Async
    public void send(UserStatistics message) {
        if (null == message) {
            log.error("用户登陆统计消息不能为空");
            return;
        }
        log.info("用户登陆统计发送,message={}", message);
        String msg = JSONObject.toJSONString(message);
        rabbitTemplate.convertAndSend("statistics-user", msg);
        log.info("用户登陆统计成功,message={}", msg);
    }

}
