package cn.quantgroup.xyqb.controller.api.v2;

import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.controller.req.v2.LoginReq;
import cn.quantgroup.xyqb.controller.req.v2.UserInfoConvertReq;
import cn.quantgroup.xyqb.model.ClientType;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.LoginBean;
import cn.quantgroup.xyqb.model.ShopMapRsp;
import cn.quantgroup.xyqb.service.v2.LoginContext;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Objects;

@RestController
@RequestMapping("/api/v2/oauth")
@Slf4j
public class OauthApiV2Controller implements IBaseController {
    private final LoginContext loginContext;

    public OauthApiV2Controller(LoginContext loginContext) {
        this.loginContext = loginContext;
    }

    /**
     * 对外内部登录接口
     * @param loginReq LoginReq
     * @return JsonResult<LoginBean>
     * @see <a href="http://yapi.quantgroups.com/project/17/interface/api/65779">对外统一登录接口</a>
     */
    @PostMapping("/login")
    public JsonResult<LoginBean> login(@RequestBody LoginReq loginReq){
        if (loginReq.getClientType() == null) {
            Long registeredFrom = getRegisteredFrom();
            Integer clientType = Objects.equals(registeredFrom,217L) || Objects.equals(registeredFrom,214L) ? ClientType.APP.ordinal():ClientType.H5.ordinal();
            loginReq.setClientType(clientType);
        }
        log.info("OauthApiV2Controller登陆接口入参:{}", JSON.toJSONString(loginReq));
        return JsonResult.buildSuccessResultGeneric(loginContext.interLogin(loginReq));
    }

    /**
     * 消费地图历史数据清洗转换
     * @param req
     * @return
     */
    @PostMapping("/shop-map/user-data-convert")
    public JsonResult<List<ShopMapRsp>> shopMapDataConvert(@RequestBody UserInfoConvertReq req){

        //手机号是否存在--注册 登录
        //微信是否存在-  若存在，和手机号是否匹配相同
        //头像昵称
        Integer tenantId = getTenantId();
        req.setTenantId(tenantId);
        return JsonResult.buildSuccessResultGeneric(loginContext.shopMapDataConvert(req));
    }
}
