package cn.quantgroup.xyqb.event;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.WechatUserInfo;
import cn.quantgroup.xyqb.service.wechat.IWechatService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import java.util.Objects;

@Slf4j
@Component
public class WechatPhoneNoUpdateEventListener implements ApplicationListener<PhoneNoUpdateEvent> {

    @Autowired
    private IWechatService wechatService;

    @Override
    public void onApplicationEvent(PhoneNoUpdateEvent event) {
        String oldPhoneNo = event.getOldPhoneNo();
        User user = event.getUser();
        WechatUserInfo userInfo = wechatService.findWechatUserInfoByPhoneNo(oldPhoneNo, user.getTenantId());
        if (Objects.isNull(userInfo)) {
            return;
        }
        if (Objects.isNull(userInfo.getPhoneNo())) {
            return;
        }

        userInfo.setPhoneNo(user.getPhoneNo());
        userInfo.setEncryptedPhoneNo(user.getPhoneNo());
        wechatService.saveWechatUserInfo(userInfo);
    }
}
