package cn.quantgroup.xyqb.entity;

import cn.quantgroup.xyqb.entity.converter.EncryptConverter;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@AllArgsConstructor
@NoArgsConstructor
@Entity
@Table(name = "wechat_bind_log")
@Data
public class WechatBindLog extends BaseEntity implements Serializable {
    private static final long serialVersionUID = -1L;
    /** 用户id*/
    @Column(name = "user_id")
    private Long userId;
    /** 微信用户唯一标识*/
    @Column(name = "open_id")
    private String openId;
    /** 应用名称*/
    @Column(name = "app_name")
    private String appName;
    /** 用户在微信平台的唯一标识*/
    @Column(name = "union_id")
    private String unionId;
    /** 加密手机号*/
    @Column(name = "encrypted_phone_no")
    @Convert(converter = EncryptConverter.class)
    private String encryptedPhoneNo;
    /** 绑定解绑类型 1:绑定 2:解绑*/
    @Column(name = "bind_type")
    private Integer bindType;
    /** 微信应用id*/
    @Column(name = "app_id")
    private String appId;
    /** 租户id*/
    @Column(name = "tenant_id")
    private Integer tenantId;


    public WechatBindLog(Long userId, String openId, String appName, String appId, Integer tenantId,String unionId,Integer bindType) {
        this.userId = userId;
        this.openId = openId;
        this.appName = appName;
        this.appId = appId;
        this.tenantId = tenantId;
        this.unionId=unionId;
        this.bindType = bindType;
    }
}
