package cn.quantgroup.xyqb.controller.middleoffice.userdetail;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.constant.UserConstant;
import cn.quantgroup.xyqb.controller.middleoffice.userdetail.req.UserDetailReq;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserInfoEntity;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.repository.IUserInfoRepository;
import cn.quantgroup.xyqb.service.user.IUserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;

/**
 * 用户实名信息
 */
@Slf4j
@RestController("middleUserDetailController")
@RequestMapping("/middle_office/user_detail")
public class UserDetailController {

    @Resource
    private IUserInfoRepository userInfoRepository;

    @Resource
    private IUserService userService;


    /**
     * 修改用户实名信息
     *
     * @param userId
     * @param userDetailReq
     * @return
     */
    @PutMapping("/{userId}")
    public JsonResult update(@PathVariable Long userId,
                             @Valid @RequestBody UserDetailReq userDetailReq,@RequestHeader(value = Constants.X_AUTH_TENANT,defaultValue = UserConstant.defaultTenantIdString) Integer tenantId) {
        UserInfoEntity userDetail = userInfoRepository.findByUserIdAndTenantId(userId,tenantId);
        if (userDetail == null) {
            return save(userId, userDetailReq,tenantId);
        }
        //更新
        userDetail.setName(userDetailReq.getName());
        userDetail = userInfoRepository.save(userDetail);
        log.info("UserDetailController update, userId:{}, name:{}", userId, userDetailReq.getName());
        return JsonResult.buildSuccessResultGeneric(userDetail);
    }

    /**
     * 保存用户实名信息
     *
     * @param userId
     * @param userDetailReq
     * @return
     */
    @PostMapping("/{userId}")
    public JsonResult save(@PathVariable Long userId,
                           @Valid @RequestBody UserDetailReq userDetailReq,@RequestHeader(value = Constants.X_AUTH_TENANT,defaultValue = UserConstant.defaultTenantIdString) Integer tenantId) {
        UserInfoEntity userDetail = userInfoRepository.findByUserIdAndTenantId(userId,tenantId);
        if (userDetail != null) {
            return JsonResult.buildSuccessResultGeneric(userDetail);
        }
        User user = userService.findById(userId,tenantId);

        userDetail = new UserInfoEntity();
        userDetail.setUserId(userId);
        userDetail.setName(userDetailReq.getName());
        userDetail.setPhoneNo(user.getPhoneNo());
        userDetail.setGender(userDetail.getGender());
        userDetail = userInfoRepository.save(userDetail);
        log.info("UserDetailController save, userId:{}, phoneNo:{}, name:{}", user.getId(), user.getPhoneNo(), userDetailReq.getName());
        return JsonResult.buildSuccessResultGeneric(userDetail);
    }

    /**
     * 根据用户 ID，查询实名信息
     *
     * @param userId
     * @return
     */
    @GetMapping("/userId/{userId}")
    public JsonResult query(@PathVariable Long userId,@RequestHeader(value = Constants.X_AUTH_TENANT,defaultValue = UserConstant.defaultTenantIdString) Integer tenantId) {
        UserInfoEntity userDetail = userInfoRepository.findByUserIdAndTenantId(userId,tenantId);
        return JsonResult.buildSuccessResultGeneric(userDetail);
    }

    /**
     * 根据手机号，查询实名信息
     *
     * @param phoneNo
     * @return
     */
    @GetMapping("/phoneNo/{phoneNo}")
    public JsonResult query(@PathVariable String phoneNo,@RequestHeader(value = Constants.X_AUTH_TENANT,defaultValue = UserConstant.defaultTenantIdString) Integer tenantId) {
        UserInfoEntity userDetail = userInfoRepository.findByPhoneNoAndTenantId(phoneNo,tenantId);
        return JsonResult.buildSuccessResultGeneric(userDetail);
    }

}
