package cn.quantgroup.xyqb.service.user.impl;

import cn.quantgroup.xyqb.entity.Contact;
import cn.quantgroup.xyqb.repository.IContactRepository;
import cn.quantgroup.xyqb.service.user.IContactService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by Miraculous on 2017/1/3.
 */
@Service
public class ContactServiceImpl implements IContactService {

    @Autowired
    private IContactRepository contactRepository;

    @Override
    @Cacheable(value = "contact", key = "'contact' + #userId", unless = "#result == null or #result.size() == 0", cacheManager = "cacheManager")
    public List<Contact> findByUserId(Long userId) {
        return contactRepository.findByUserId(userId);
    }


}
