package cn.quantgroup.xyqb.model;

import cn.quantgroup.xyqb.entity.Address;
import cn.quantgroup.xyqb.entity.Contact;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 用户综合信息数据模型
 *
 * @author renwc
 * @date 2018-01-04
 */
@Data
public class UserAssociationModel implements Serializable {
    private static final long serialVersionUID = -1L;
    private Long id;
    private String uuid;
    private String phoneNo;
    private String idNo;
    private String name;
    private String gender;
    private String marryStatus;
    private String educationEnum;
    private String occupationEnum;
    private String qq;
    private Long registerFrom;
    private Long merchantId;
    private List<AddressModel> addressList;
    private List<ContactModel> contactList;

    /**
     * 填充地址模型列表
     *
     * @param entitylist
     */
    public void putAddressList(List<Address> entitylist) {
        if (Objects.isNull(entitylist)) {
            return;
        }
        if (Objects.isNull(this.addressList)) {
            this.addressList = new ArrayList<>(entitylist.size());
        }
        for (Address entity : entitylist) {
            this.addressList.add(AddressModel.entity2Model(entity));
        }
    }

    /**
     * 填充联系人模型列表
     *
     * @param entitylist
     */
    public void putContactList(List<Contact> entitylist) {
        if (Objects.isNull(entitylist)) {
            return;
        }
        if (Objects.isNull(this.contactList)) {
            this.contactList = new ArrayList<>(entitylist.size());
        }
        for (Contact entity : entitylist) {
            this.contactList.add(ContactModel.entity2Model(entity));
        }
    }
}
