package token;

import cn.quantgroup.xyqb.Bootstrap;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

@RunWith(SpringRunner.class)
@SpringBootTest(classes = Bootstrap.class)
@WebAppConfiguration
public class OneTimeTokenTests {
  final String userName = "root";
  final String password = "！QAZ2wsx";
  final String phoneNo = "13461067662";

  private MockMvc mvc;
  @Autowired
  WebApplicationContext webApplicationConnect;

  @Before
  public void setUp() throws JsonProcessingException {
    mvc = MockMvcBuilders.webAppContextSetup(webApplicationConnect).build();

  }

  /**
   * 测试Server是否可达
   * @throws Exception
   */
  @Test
  public void testServer() throws Exception {
    mvc.perform(MockMvcRequestBuilders.get("/").accept(MediaType.APPLICATION_JSON))
            .andExpect(status().isOk());
    mvc.perform(MockMvcRequestBuilders.get("/token/oneTime").accept(MediaType.APPLICATION_JSON))
            .andExpect(status().isOk());
  }

  /**
   * 测试OneTime-Token发放服务
   * @throws Exception
   */
  @Test
  public void testOneTimeToken() throws Exception{
    String tokenOnceUri = "/token/oneTime";
    MvcResult mvcResult = mvc.perform(MockMvcRequestBuilders.get(tokenOnceUri).accept(MediaType.APPLICATION_JSON))
            .andExpect(status().isOk())
            .andReturn();
    String content = mvcResult.getResponse().getContentAsString();
    JSONObject jsonResult = JSON.parseObject(new String(content));
    Object code = jsonResult.get("code");
    Assert.assertEquals("0000", code);
    Object data = jsonResult.getString("data");
    Assert.assertNotNull(data);
    String oneTimeToken = String.valueOf(data);
    Assert.assertNotEquals("", oneTimeToken);
  }

  /**
   * 测试OneTime-Token切面
   * @throws Exception
   */
  // TODO 用户注册先不加OneTime-Token校验，进一步确认后再添加或删除本用例
  //@Test
  public void testAspect() throws Exception{
    // 获取OneTime-Token
    String oneTimeTokenUri = "/token/oneTime";
    MvcResult mvcResult = mvc.perform(MockMvcRequestBuilders.get(oneTimeTokenUri).accept(MediaType.APPLICATION_JSON))
            .andExpect(status().isOk())
            .andReturn();
    String content = mvcResult.getResponse().getContentAsString();
    JSONObject jsonResult = JSON.parseObject(new String(content));
    Object code = jsonResult.get("code");
    Assert.assertEquals("0000", code);
    Object data = jsonResult.getString("data");
    Assert.assertNotNull(data);
    String oneTimeToken = String.valueOf(data);
    Assert.assertNotEquals("", oneTimeToken);
    // 第一次使用OneTime-Token
    String aspectUri = "/user/loginForH5";
    mvcResult = mvc.perform(MockMvcRequestBuilders.get(aspectUri).accept(MediaType.APPLICATION_JSON)
            .param("phoneNo", userName)
            .param("password", password))
            .andExpect(status().isOk())
            .andReturn();
    content = mvcResult.getResponse().getContentAsString();
    jsonResult = JSON.parseObject(new String(content));
    code = jsonResult.get("code");
    Object businessCode = jsonResult.get("businessCode");
    Assert.assertEquals("0000", code);
    Assert.assertNotEquals("0002", businessCode);
    // 使用过期的TokenOnce
    mvcResult = mvc.perform(MockMvcRequestBuilders.get(aspectUri).accept(MediaType.APPLICATION_JSON)
            .param("phoneNo", userName)
            .param("password", password))
            .andExpect(status().isOk())
            .andReturn();
    content = mvcResult.getResponse().getContentAsString();
    jsonResult = JSON.parseObject(new String(content));
    code = jsonResult.get("code");
    Assert.assertEquals("0000", code);
    businessCode = jsonResult.get("businessCode");
    Assert.assertEquals("0002", businessCode);
    // 不使用TokenOnce
    mvcResult = mvc.perform(MockMvcRequestBuilders.get(aspectUri).accept(MediaType.APPLICATION_JSON)
            .param("phoneNo", userName)
            .param("password", password))
            .andExpect(status().isOk())
            .andReturn();
    content = mvcResult.getResponse().getContentAsString();
    jsonResult = JSON.parseObject(new String(content));
    code = jsonResult.get("code");
    Assert.assertEquals("0000", code);
    businessCode = jsonResult.get("businessCode");
    Assert.assertEquals("0002", businessCode);
  }

}
