package demo;

import cn.quantgroup.xyqb.Bootstrap;
import com.ctrip.framework.apollo.spring.config.ApolloPropertySourceInitializer;
import jdk.nashorn.internal.runtime.regexp.joni.Config;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.ConfigFileApplicationContextInitializer;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.SpringBootTest.WebEnvironment;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;


/**
 * 控制层测试用例
 * @author renwc
 * @date 2018-01-05
 */
//@ContextConfiguration(classes = Config.class, initializers = ConfigFileApplicationContextInitializer.class)
@ContextConfiguration(initializers = ApolloPropertySourceInitializer.class)
@Slf4j
@RunWith(SpringRunner.class)
@SpringBootTest(webEnvironment= WebEnvironment.RANDOM_PORT)
public class WebTests {

    @Autowired
    private TestRestTemplate restTemplate;

    @Test
    public void contextLoads() {
        Assert.assertTrue(true);
    }

    @Test
    public void test() {
        ResponseEntity<String> phil = restTemplate.getForEntity("/{model}/list", String.class, "log");
        Assert.assertEquals(phil.getStatusCode(), HttpStatus.OK);
    }

}
