package cn.quantgroup.xyqb.service.captcha.impl;

import cn.quantgroup.xyqb.entity.GeetestLogEntity;
import cn.quantgroup.xyqb.model.ClientType;
import cn.quantgroup.xyqb.model.SettingType;
import cn.quantgroup.xyqb.repository.IGeetestLogRepository;
import cn.quantgroup.xyqb.service.captcha.IGeetestLogService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

/**
 * @author xufei on 2018/1/30.
 */
@Service
@Slf4j
public class GeetestLogServiceImpl implements IGeetestLogService {

    @Resource
    private IGeetestLogRepository geetestLogRepository;

    @Override
    public Long saveGeetestLog(String phoneNo, String clientType, String settingType, Map<String, String> imgMap) {
        GeetestLogEntity geetestLogEntity = new GeetestLogEntity();
        geetestLogEntity.setPhoneNo(phoneNo);
        geetestLogEntity.setDataSource(ClientType.valueByName(clientType).ordinal());
        geetestLogEntity.setSetting(SettingType.valueByName(settingType).ordinal());
        geetestLogEntity.setChallenge(imgMap.get("reChallenge"));
        geetestLogEntity.setCaptchaId(imgMap.get("gt"));
        geetestLogEntity = geetestLogRepository.saveAndFlush(geetestLogEntity);
        return geetestLogEntity.getId();
    }

    @Override
    public void updateGeetestLog(String geetestLogId, String initializeDt, String registerDt, String registerReDt, Map<String, Object> result) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            GeetestLogEntity geetestLogEntity = geetestLogRepository.getOne(Long.parseLong(geetestLogId));
            if (geetestLogEntity != null) {
                if (StringUtils.isNotBlank(initializeDt) && StringUtils.isNotBlank(registerDt) && StringUtils.isNotBlank(registerReDt)) {
                    geetestLogEntity.setInitializeDt(simpleDateFormat.parse(initializeDt));
                    geetestLogEntity.setRegisterDt(simpleDateFormat.parse(registerDt));
                    geetestLogEntity.setRegisterReDt(simpleDateFormat.parse(registerReDt));
                }
                geetestLogEntity.setValidataDt((Date) result.get("validataDt"));
                geetestLogEntity.setValidataReDt((Date) result.get("validataReDt"));
                geetestLogEntity.setValidataResult(result.getOrDefault("validataResult", "").toString());
                geetestLogEntity.setValidataMethod(result.getOrDefault("validataMethod", "").toString());
                geetestLogRepository.save(geetestLogEntity);
            }
        } catch (Exception e) {
            log.error("修改极验验证二次验证失败--{}", e.getMessage());
        }
    }

    @Override
    public void updateByUidGeetestLog(Long geetestLogId, Long id) {
        try {
            GeetestLogEntity geetestLogEntity = geetestLogRepository.getOne(geetestLogId);
            geetestLogEntity.setUserId(id);
            geetestLogRepository.save(geetestLogEntity);
        } catch (Exception e) {
            log.error("修改极验验证用户userId失败--{}", e.getMessage());
        }
    }

}
