package cn.quantgroup.xyqb.controller.middleoffice.user;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.event.DisableActiveEvent;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.service.user.IUserService;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * 用户信息
 */
@RestController("middleUserController")
@RequestMapping("/middle_office/user")
public class UserController {

    @Resource
    private IUserService userService;

    @Resource
    private ApplicationEventPublisher applicationEventPublisher;

    @PutMapping("/enable/{userId}")
    public JsonResult enable(@PathVariable Long userId) {
        User user = userService.findById(userId);
        if (user == null) {
            //todo 用户不存在，怎么处理
            return JsonResult.buildSuccessResult();
        }
        user.setEnable(true);
        userService.saveUser(user);
        //通知消息中心
        applicationEventPublisher.publishEvent(new DisableActiveEvent(this,user));
        return JsonResult.buildSuccessResult();
    }

    @PutMapping("/disable/{userId}")
    public JsonResult disable(@PathVariable Long userId) {
        User user = userService.findById(userId);
        if (user == null) {
            //todo 用户不存在，怎么处理
            return JsonResult.buildSuccessResult();
        }
        user.setEnable(false);
        //清理缓存
        userService.saveUser(user);
        //通知消息中心
        applicationEventPublisher.publishEvent(new DisableActiveEvent(this,user));

        return JsonResult.buildSuccessResult();
    }

    @GetMapping("/userId/{userId}")
    public JsonResult user(@PathVariable Long userId) {
        User user = userService.findById(userId);
        //TODO convert to userVO
        return JsonResult.buildSuccessResultGeneric(user);
    }


    @GetMapping("/phoneNo/{phoneNo}")
    public JsonResult user(@PathVariable String phoneNo) {
        User user = userService.findByPhoneInDb(phoneNo);
        //TODO convert to userVO
        return JsonResult.buildSuccessResultGeneric(user);
    }

    @GetMapping("/uuid/{uuid}")
    public JsonResult uuid(@PathVariable String uuid) {
        User user = userService.findByUuidWithCache(uuid);
        //TODO convert to userVO
        return JsonResult.buildSuccessResultGeneric(user);
    }
    /**
     * 根据uuid或者userids 获取用户信息
     * @param params
     * @return
     */
    @PostMapping("/getByUuidsOrUserIds")
    public JsonResult getByUuidsOrUserIds(@RequestBody Map<String,Object> params){

        List<String> vals = (List<String>)params.get("vals");
        Integer type = (Integer)params.get("type");
        if(type== null || (type !=1 && type !=2)){
            return JsonResult.buildErrorStateResult("type错误",null);
        }

        return JsonResult.buildSuccessResultGeneric(userService.findByUuidsOrUserIds(vals, type));
    }
}
