package cn.quantgroup.xyqb.config;

import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * 配置文件监听
 * 当apollo配置文件发生变更的时候，监听所有被{@link RefreshScope}修饰的类，这些类进行删除，在使用的是重新加载
 */
@Component
@Slf4j
public class ApolloConfigListener implements ApplicationContextAware {

  private ApplicationContext applicationContext;

  @Autowired
  RefreshScope refreshScope;

  @ApolloConfigChangeListener(value = {"application"})
  public void configChange(ConfigChangeEvent event) {
    Set<String> changedKeys = event.changedKeys();
    for (String changedKey : changedKeys) {
      log.info("changed key = {}", changedKey);
      log.info("oldValue={},newValue= {}", event.getChange(changedKey).getOldValue(),
          event.getChange(changedKey).getNewValue());
    }
    this.applicationContext.publishEvent(new EnvironmentChangeEvent(event.changedKeys()));
    refreshScope.refreshAll();
  }

  @Override
  public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
    this.applicationContext = applicationContext;
  }
}