package cn.quantgroup.xyqb.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 返回用户当前登陆的终端渠道
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class UserLoginVO implements Serializable {
    private static final long serialVersionUID = -1L;
    /** 用户当前登陆的终端渠道*/
    private Long currentRegisteredFrom;
    /** 用户所有登陆的终端渠道(这里 要把金融的排除掉) */
    private List<LoginChannelInfo> registeredFromList;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class LoginChannelInfo implements Serializable {
        private static final long serialVersionUID = -1L;
        /** 渠道*/
        private Long registeredFrom;
        /** 设备号*/
        private String deviceId;
        /** app渠道(app的下载渠道)*/
        private String appChannel;
    }
}
