package cn.quantgroup.xyqb.xxlJob;

import cn.quantgroup.xyqb.constant.UserConstant;
import cn.quantgroup.xyqb.entity.UserAttached;
import cn.quantgroup.xyqb.entity.UserInfoEntity;
import cn.quantgroup.xyqb.repository.IUserAttachedRepository;
import cn.quantgroup.xyqb.repository.IUserInfoRepository;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 第一次上线对历史数据清理程序
 */
@Component
public class UserAttachedMigrationJobHandler {
    @Autowired
    private IUserAttachedRepository userAttachedRepository;
    @Autowired
    private IUserInfoRepository userInfoRepository;

    @XxlJob(value = "userTagCleanJobHandler")
    public ReturnT<String> execute() {
        Pageable pageable = new PageRequest(0, 500);
        Page<UserAttached> userAttachedPage = userAttachedRepository.findAll(pageable);
        while (CollectionUtils.isNotEmpty(userAttachedPage.getContent())) {
            userAttachedPage.getContent().forEach(i -> {
                UserInfoEntity userInfoEntity = userInfoRepository.findByUserIdAndTenantId(i.getUserId(), UserConstant.defaultTenantId);
                if (userInfoEntity == null) {
                    userInfoEntity = new UserInfoEntity();
                    userInfoEntity.setUserId(i.getUserId());
                    userInfoEntity.setTenantId(UserConstant.defaultTenantId);
                }

                userInfoEntity.setPhoto(i.getAvatar());
                userInfoEntity.setNickName(i.getNick());
                userInfoRepository.save(userInfoEntity);
            });


            pageable = new PageRequest(pageable.getPageNumber() + 1, pageable.getPageSize());
            userAttachedPage = userAttachedRepository.findAll(pageable);
        }
        return ReturnT.SUCCESS;
    }
}
