package cn.quantgroup.xyqb.remote;

import cn.quantgroup.xyqb.model.OauthResult;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name = "stms", url = "${stms.https}")
public interface StmsRemoteService {
  @PostMapping("/v2/oauth/currentuserinfo")
  OauthResult checkToken(@RequestHeader("Access-Token") String accessToken);

  @GetMapping(value = "/v2/oauth/permission")
  OauthResult checkPermission(@RequestHeader("Access-Token") String accessToken,
                              @RequestHeader("Referer") String referer, @RequestParam("tenantId") String tenantId);

}
