package cn.quantgroup.xyqb.entity;

import cn.quantgroup.xyqb.model.Gender;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;

@EqualsAndHashCode(callSuper = true)
@Data
@Entity
@Table(name = "user_info")
public class UserInfoEntity extends BaseEntity implements Serializable {
    @Column(name = "user_id")
    private Long userId;

    @Column(name = "phone_no")
    private String phoneNo;

    //0 未知 1 女 2 男
    @Column(name = "gender")
    private Gender gender;

    @Column(name = "email")
    private String email;

    @Column(name = "qq")
    private String qq;

    @Column(name = "name")
    private String name;
    @Column(name = "photo")
    private String photo;
    @Column(name = "birthday")
    private LocalDate birthday;
    @Column(name = "province_id")
    private Integer provinceId;

    @Column(name = "city_id")
    private Integer cityId;

    @Column(name = "address")
    private String address;
    @Column(name = "tenant_id")
    private Integer tenantId;
}
