package cn.quantgroup.xyqb.event;

import cn.quantgroup.xyqb.entity.UserHashMapping;
import cn.quantgroup.xyqb.model.UserRegisterParam;
import cn.quantgroup.xyqb.repository.IUserHashMappingRepository;
import cn.quantgroup.xyqb.util.encrypt.MD5Util;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class PhoneHashEventListener implements ApplicationListener<RegisterEvent> {

    @Autowired
    private IUserHashMappingRepository userHashMappingRepository;

    @Override
    public void onApplicationEvent(RegisterEvent event) {
        UserRegisterParam userRegisterParam = event.getUserRegisterParam();
        String phoneNo = userRegisterParam.getPhoneNo();
        Long userId = userRegisterParam.getUser().getId();

        UserHashMapping userHashMapping = userHashMappingRepository.findByUserId(userId);
        if (userHashMapping != null && userHashMapping.getIdNoMd5() != null) {
            //已存在的用户, 并且已存在身份证号
            return;
        }
        if (userHashMapping == null) {
            //创建一个新的
            userHashMapping = new UserHashMapping(userId);
        }
        //无论如何都更新手机号
        String phoneNoMd5 = MD5Util.build(phoneNo);
        userHashMapping.setPhoneNoMd5(phoneNoMd5);
        String idNo = userRegisterParam.getIdNo();

        //如果有身份证号. 更新一下
        if (StringUtils.isNotEmpty(idNo)) {
            userHashMapping.setIdNoMd5(MD5Util.build(idNo));
        }

        userHashMappingRepository.saveAndFlush(userHashMapping);

    }
}
