package cn.quantgroup.xyqb.entity;

import cn.quantgroup.user.enums.Relation;
import cn.quantgroup.xyqb.model.Tuple;
import cn.quantgroup.xyqb.util.ValidationUtil;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

/**
 * Created by 11 on 2016/12/30.
 */
@Data
@Entity
@Table(name = "contact")
public class Contact extends BaseEntity implements Serializable {
    private static final long serialVersionUID = -1L;

    @Column(name = "user_id")
    private Long userId;
    @Column(name = "name")
    private String name;
    @Column(name = "phone_no")
    private String phoneNo;
    @Column(name = "relation")
    private Relation relation;

    /**
     * 数据合法性校验
     *
     * @return
     */
    public boolean valid() {
        return (ValidationUtil.validatePhoneNo(this.phoneNo) && ValidationUtil.validateChinese(this.name));
    }

    public Tuple<String, Boolean> validAndResult() {
        boolean phoneValidRes = ValidationUtil.validatePhoneNo(this.phoneNo);
        if (!phoneValidRes) {
            return new Tuple<>("手机号错误", false);
        }
        boolean nameValid = ValidationUtil.validateChinese(this.name);
        if (!nameValid) {
            return new Tuple<>("姓名错误", false);
        }
        return new Tuple<>("", true);
    }

}
