package cn.quantgroup.xyqb.security;

import java.security.Principal;
import java.util.Properties;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.StringUtils;

/**
 * Created by Administrator on 2021/7/1 0001.
 */
public abstract class CustomerAuthenticationManager implements AuthenticationManager {

    private Principal principal;

    private Properties properties = new Properties();

    public CustomerAuthenticationManager() {
    }

    public Properties getProperties() {
        return properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getProperty(String key) {
        return properties.getProperty(key);
    }

    public void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    public Principal getPrincipal() {
        return principal;
    }

    public Authentication authenticate(String credentials) throws AuthenticationException {
        Authentication auth = getCredentials(credentials);

        if (StringUtils.isEmpty(auth.getPrincipal()) || StringUtils.isEmpty(auth.getCredentials())) {
            throw new BadCredentialsException("authorization credentials does not look like urora. " + auth);
        }

        auth = authenticate(auth);

        return auth;
    }

    public abstract void init();

    public abstract Authentication getCredentials(String message) throws AuthenticationException;

    public abstract Authentication authenticate(Authentication authentication) throws AuthenticationException;

}
